<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mal ServiceType
 * @subpackage Services
 */
class Mal extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * MalBedelliGonderiKomisyonFaturaListesi
     * Meta informations extracted from the WSDL
     * - documentation: İki Tarih Arası Kesilen yada Ödemesi yapılan komisyon faturalarını listeler. pTarihType değeri FATURA_TARIHI veya ODEME_TARIHI olmalıdır.) | İki Tarih Arası Kesilen yada Ödemesi yapılan komisyon faturalarını listeler.
     * pTarihType değeri FATURA_TARIHI veya ODEME_TARIHI olmalıdır.)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MalBedelliGonderiKomisyonFaturaListesi $parameters
     * @return \StructType\MalBedelliGonderiKomisyonFaturaListesiResponse|bool
     */
    public function MalBedelliGonderiKomisyonFaturaListesi(\StructType\MalBedelliGonderiKomisyonFaturaListesi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MalBedelliGonderiKomisyonFaturaListesi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * MalBedelliGonderiKomisyonFaturaDetay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MalBedelliGonderiKomisyonFaturaDetay $parameters
     * @return \StructType\MalBedelliGonderiKomisyonFaturaDetayResponse|bool
     */
    public function MalBedelliGonderiKomisyonFaturaDetay(\StructType\MalBedelliGonderiKomisyonFaturaDetay $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MalBedelliGonderiKomisyonFaturaDetay($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MalBedelliGonderiKomisyonFaturaDetayResponse|\StructType\MalBedelliGonderiKomisyonFaturaListesiResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
