<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kargo ServiceType
 * @subpackage Services
 */
class Kargo extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named KargoUcretHesaplaFace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KargoUcretHesaplaFace $parameters
     * @return \StructType\KargoUcretHesaplaFaceResponse|bool
     */
    public function KargoUcretHesaplaFace(\StructType\KargoUcretHesaplaFace $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->KargoUcretHesaplaFace($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KargoUcretHesaplaFaceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
