<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gonderi ServiceType
 * @subpackage Services
 */
class Gonderi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GonderiSonDurumlari
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GonderiSonDurumlari $parameters
     * @return \StructType\GonderiSonDurumlariResponse|bool
     */
    public function GonderiSonDurumlari(\StructType\GonderiSonDurumlari $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GonderiSonDurumlari($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GonderiSonDurumlariResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
