<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kurye ServiceType
 * @subpackage Services
 */
class Kurye extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named KuryeCagirFace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KuryeCagirFace $parameters
     * @return \StructType\KuryeCagirFaceResponse|bool
     */
    public function KuryeCagirFace(\StructType\KuryeCagirFace $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->KuryeCagirFace($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KuryeCagirFaceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
