<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Fatura ServiceType
 * @subpackage Services
 */
class Fatura extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FaturaSiparisBilgiTz
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FaturaSiparisBilgiTz $parameters
     * @return \StructType\FaturaSiparisBilgiTzResponse|bool
     */
    public function FaturaSiparisBilgiTz(\StructType\FaturaSiparisBilgiTz $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FaturaSiparisBilgiTz($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FaturaSiparisBilgiTzResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
