<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MusteriBayiIslem StructType
 * @subpackage Structs
 */
class MusteriBayiIslem extends AbstractStructBase
{
    /**
     * The pRequestType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pRequestType;
    /**
     * The pWsUsername
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pWsUsername;
    /**
     * The pWsPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pWsPassword;
    /**
     * The pMusteriBayiInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MusteriBayiInfo
     */
    public $pMusteriBayiInfo;
    /**
     * Constructor method for MusteriBayiIslem
     * @uses MusteriBayiIslem::setPRequestType()
     * @uses MusteriBayiIslem::setPWsUsername()
     * @uses MusteriBayiIslem::setPWsPassword()
     * @uses MusteriBayiIslem::setPMusteriBayiInfo()
     * @param string $pRequestType
     * @param string $pWsUsername
     * @param string $pWsPassword
     * @param \StructType\MusteriBayiInfo $pMusteriBayiInfo
     */
    public function __construct($pRequestType = null, $pWsUsername = null, $pWsPassword = null, \StructType\MusteriBayiInfo $pMusteriBayiInfo = null)
    {
        $this
            ->setPRequestType($pRequestType)
            ->setPWsUsername($pWsUsername)
            ->setPWsPassword($pWsPassword)
            ->setPMusteriBayiInfo($pMusteriBayiInfo);
    }
    /**
     * Get pRequestType value
     * @return string
     */
    public function getPRequestType()
    {
        return $this->pRequestType;
    }
    /**
     * Set pRequestType value
     * @uses \EnumType\RequestType::valueIsValid()
     * @uses \EnumType\RequestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pRequestType
     * @return \StructType\MusteriBayiIslem
     */
    public function setPRequestType($pRequestType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RequestType::valueIsValid($pRequestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RequestType', is_array($pRequestType) ? implode(', ', $pRequestType) : var_export($pRequestType, true), implode(', ', \EnumType\RequestType::getValidValues())), __LINE__);
        }
        $this->pRequestType = $pRequestType;
        return $this;
    }
    /**
     * Get pWsUsername value
     * @return string|null
     */
    public function getPWsUsername()
    {
        return $this->pWsUsername;
    }
    /**
     * Set pWsUsername value
     * @param string $pWsUsername
     * @return \StructType\MusteriBayiIslem
     */
    public function setPWsUsername($pWsUsername = null)
    {
        // validation for constraint: string
        if (!is_null($pWsUsername) && !is_string($pWsUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pWsUsername, true), gettype($pWsUsername)), __LINE__);
        }
        $this->pWsUsername = $pWsUsername;
        return $this;
    }
    /**
     * Get pWsPassword value
     * @return string|null
     */
    public function getPWsPassword()
    {
        return $this->pWsPassword;
    }
    /**
     * Set pWsPassword value
     * @param string $pWsPassword
     * @return \StructType\MusteriBayiIslem
     */
    public function setPWsPassword($pWsPassword = null)
    {
        // validation for constraint: string
        if (!is_null($pWsPassword) && !is_string($pWsPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pWsPassword, true), gettype($pWsPassword)), __LINE__);
        }
        $this->pWsPassword = $pWsPassword;
        return $this;
    }
    /**
     * Get pMusteriBayiInfo value
     * @return \StructType\MusteriBayiInfo|null
     */
    public function getPMusteriBayiInfo()
    {
        return $this->pMusteriBayiInfo;
    }
    /**
     * Set pMusteriBayiInfo value
     * @param \StructType\MusteriBayiInfo $pMusteriBayiInfo
     * @return \StructType\MusteriBayiIslem
     */
    public function setPMusteriBayiInfo(\StructType\MusteriBayiInfo $pMusteriBayiInfo = null)
    {
        $this->pMusteriBayiInfo = $pMusteriBayiInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MusteriBayiIslem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
