<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gonderi ServiceType
 * @subpackage Services
 */
class Gonderi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GonderiTeslimatProblemleri
     * Meta informations extracted from the WSDL
     * - documentation: Gönderileriniz İçin İletilen İade istekleri Listesidir !
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GonderiTeslimatProblemleri $parameters
     * @return \StructType\GonderiTeslimatProblemleriResponse|bool
     */
    public function GonderiTeslimatProblemleri(\StructType\GonderiTeslimatProblemleri $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GonderiTeslimatProblemleri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GonderiTeslimatProblemiIadeYaniti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GonderiTeslimatProblemiIadeYaniti $parameters
     * @return \StructType\GonderiTeslimatProblemiIadeYanitiResponse|bool
     */
    public function GonderiTeslimatProblemiIadeYaniti(\StructType\GonderiTeslimatProblemiIadeYaniti $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GonderiTeslimatProblemiIadeYaniti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GonderiTeslimatProblemiIadeYanitiResponse|\StructType\GonderiTeslimatProblemleriResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
