<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bayi ServiceType
 * @subpackage Services
 */
class Bayi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BayiAdresiGecersiz
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BayiAdresiGecersiz $parameters
     * @return \StructType\BayiAdresiGecersizResponse|bool
     */
    public function BayiAdresiGecersiz(\StructType\BayiAdresiGecersiz $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BayiAdresiGecersiz($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BayiIhbarGirisi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BayiIhbarGirisi $parameters
     * @return \StructType\BayiIhbarGirisiResponse|bool
     */
    public function BayiIhbarGirisi(\StructType\BayiIhbarGirisi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BayiIhbarGirisi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BayiAdresiGecersizResponse|\StructType\BayiIhbarGirisiResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
