<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Siparis ServiceType
 * @subpackage Services
 */
class Siparis extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SiparisGirisiDetayli
     * Meta informations extracted from the WSDL
     * - documentation: Müşteri Sipariş Kayıt | Müşteri Sipariş Kayıt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisGirisiDetayli $parameters
     * @return \StructType\SiparisGirisiDetayliResponse|bool
     */
    public function SiparisGirisiDetayli(\StructType\SiparisGirisiDetayli $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SiparisGirisiDetayli($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisGirisiDetayliV2
     * Meta informations extracted from the WSDL
     * - documentation: Müşteri Sipariş Kayıt (SiparisGirisDetayli ya ek olarak Alıcının Cep ve Ev Telefonu Bilgileri Eklendi) | Müşteri Sipariş Kayıt (SiparisGirisDetayli ya ek olarak Alıcının Cep ve Ev Telefonu Bilgileri Eklendi)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisGirisiDetayliV2 $parameters
     * @return \StructType\SiparisGirisiDetayliV2Response|bool
     */
    public function SiparisGirisiDetayliV2(\StructType\SiparisGirisiDetayliV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SiparisGirisiDetayliV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisGirisiDetayliV3
     * Meta informations extracted from the WSDL
     * - documentation: Müşteri Sipariş Kayıt (SiparisGirisDetayliV2 ye ek olarak pGonderiHizmetSekli , pTeslimSekli , pPlatformKisaAdi ve pPlatformSatisKodu, Eklendi) | Müşteri Sipariş Kayıt (SiparisGirisDetayliV2 ye ek olarak pGonderiHizmetSekli ,
     * pTeslimSekli , pPlatformKisaAdi ve pPlatformSatisKodu, Eklendi)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisGirisiDetayliV3 $parameters
     * @return \StructType\SiparisGirisiDetayliV3Response|bool
     */
    public function SiparisGirisiDetayliV3(\StructType\SiparisGirisiDetayliV3 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SiparisGirisiDetayliV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisGirisiDetayliV4
     * Meta informations extracted from the WSDL
     * - documentation: Müşteri Sipariş Kayıt (SiparisGirisDetayliV3 metoduna ek olarak Parça Referans List parameteresi eklendi ! ) | Müşteri Sipariş Kayıt (SiparisGirisDetayliV3 metoduna ek olarak Parça Referans List parameteresi eklendi ! )
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisGirisiDetayliV4 $parameters
     * @return \StructType\SiparisGirisiDetayliV4Response|bool
     */
    public function SiparisGirisiDetayliV4(\StructType\SiparisGirisiDetayliV4 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SiparisGirisiDetayliV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisAliciKayit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisAliciKayit $parameters
     * @return \StructType\SiparisAliciKayitResponse|bool
     */
    public function SiparisAliciKayit(\StructType\SiparisAliciKayit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SiparisAliciKayit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisUpdateParcastring
     * Meta informations extracted from the WSDL
     * - documentation: Daha önce gönderilmiş olan sipariş verisindeki irsaliye_no, adet , desi, kilo ve kilodesi bilgisini günceller | Daha önce gönderilmiş olan sipariş verisindeki irsaliye_no, adet , desi, kilo ve kilodesi bilgisini günceller
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisUpdateParcastring $parameters
     * @return \StructType\SiparisUpdateParcastringResponse|bool
     */
    public function SiparisUpdateParcastring(\StructType\SiparisUpdateParcastring $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SiparisUpdateParcastring($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisUpdateParcastringV2
     * Meta informations extracted from the WSDL
     * - documentation: Daha önce gönderilmiş olan sipariş verisindeki irsaliye_no, adet , desi, kilo , kilodesi ve ürün bedeli bilgisini günceller | Daha önce gönderilmiş olan sipariş verisindeki irsaliye_no, adet , desi, kilo , kilodesi ve
     * ürün bedeli bilgisini günceller
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SiparisUpdateParcastringV2 $parameters
     * @return \StructType\SiparisUpdateParcastringV2Response|bool
     */
    public function SiparisUpdateParcastringV2(\StructType\SiparisUpdateParcastringV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SiparisUpdateParcastringV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SiparisAliciKayitResponse|\StructType\SiparisGirisiDetayliResponse|\StructType\SiparisGirisiDetayliV2Response|\StructType\SiparisGirisiDetayliV3Response|\StructType\SiparisGirisiDetayliV4Response|\StructType\SiparisUpdateParcastringResponse|\StructType\SiparisUpdateParcastringV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
