<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Musteri ServiceType
 * @subpackage Services
 */
class Musteri extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MusteriSiparisKayit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriSiparisKayit $parameters
     * @return \StructType\MusteriSiparisKayitResponse|bool
     */
    public function MusteriSiparisKayit(\StructType\MusteriSiparisKayit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriSiparisKayit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriSiparisIptal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriSiparisIptal $parameters
     * @return \StructType\MusteriSiparisIptalResponse|bool
     */
    public function MusteriSiparisIptal(\StructType\MusteriSiparisIptal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriSiparisIptal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriBayiBilgileri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriBayiBilgileri $parameters
     * @return \StructType\MusteriBayiBilgileriResponse|bool
     */
    public function MusteriBayiBilgileri(\StructType\MusteriBayiBilgileri $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriBayiBilgileri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriBayiIslem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriBayiIslem $parameters
     * @return \StructType\MusteriBayiIslemResponse|bool
     */
    public function MusteriBayiIslem(\StructType\MusteriBayiIslem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriBayiIslem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriOzelRapor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriOzelRapor $parameters
     * @return \StructType\MusteriOzelRaporResponse|bool
     */
    public function MusteriOzelRapor(\StructType\MusteriOzelRapor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriOzelRapor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriTeslimatIptalIstegi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriTeslimatIptalIstegi $parameters
     * @return \StructType\MusteriTeslimatIptalIstegiResponse|bool
     */
    public function MusteriTeslimatIptalIstegi(\StructType\MusteriTeslimatIptalIstegi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriTeslimatIptalIstegi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MusteriBayiBilgileriResponse|\StructType\MusteriBayiIslemResponse|\StructType\MusteriOzelRaporResponse|\StructType\MusteriSiparisIptalResponse|\StructType\MusteriSiparisKayitResponse|\StructType\MusteriTeslimatIptalIstegiResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
