<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for MNGG ServiceType
 * @subpackage Services
 */
class MNGG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MNGGonderiBarkod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MNGGonderiBarkod $parameters
     * @return \StructType\MNGGonderiBarkodResponse|bool
     */
    public function MNGGonderiBarkod(\StructType\MNGGonderiBarkod $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MNGGonderiBarkod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MNGGonderiBarkodResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
