<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Baglanti ServiceType
 * @subpackage Services
 */
class Baglanti extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Baglanti_Test
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Baglanti_Test $parameters
     * @return \StructType\Baglanti_TestResponse|bool
     */
    public function Baglanti_Test(\StructType\Baglanti_Test $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Baglanti_Test($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Baglanti_TestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
