<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GonderiParca StructType
 * @subpackage Structs
 */
class GonderiParca extends AbstractStructBase
{
    /**
     * The Kg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Kg;
    /**
     * The Desi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Desi;
    /**
     * The Adet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Adet;
    /**
     * The Icerik
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Icerik;
    /**
     * The ParcaBarkod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParcaBarkod;
    /**
     * Constructor method for GonderiParca
     * @uses GonderiParca::setKg()
     * @uses GonderiParca::setDesi()
     * @uses GonderiParca::setAdet()
     * @uses GonderiParca::setIcerik()
     * @uses GonderiParca::setParcaBarkod()
     * @param int $kg
     * @param int $desi
     * @param int $adet
     * @param string $icerik
     * @param string $parcaBarkod
     */
    public function __construct($kg = null, $desi = null, $adet = null, $icerik = null, $parcaBarkod = null)
    {
        $this
            ->setKg($kg)
            ->setDesi($desi)
            ->setAdet($adet)
            ->setIcerik($icerik)
            ->setParcaBarkod($parcaBarkod);
    }
    /**
     * Get Kg value
     * @return int
     */
    public function getKg()
    {
        return $this->Kg;
    }
    /**
     * Set Kg value
     * @param int $kg
     * @return \StructType\GonderiParca
     */
    public function setKg($kg = null)
    {
        // validation for constraint: int
        if (!is_null($kg) && !(is_int($kg) || ctype_digit($kg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kg, true), gettype($kg)), __LINE__);
        }
        $this->Kg = $kg;
        return $this;
    }
    /**
     * Get Desi value
     * @return int
     */
    public function getDesi()
    {
        return $this->Desi;
    }
    /**
     * Set Desi value
     * @param int $desi
     * @return \StructType\GonderiParca
     */
    public function setDesi($desi = null)
    {
        // validation for constraint: int
        if (!is_null($desi) && !(is_int($desi) || ctype_digit($desi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($desi, true), gettype($desi)), __LINE__);
        }
        $this->Desi = $desi;
        return $this;
    }
    /**
     * Get Adet value
     * @return int
     */
    public function getAdet()
    {
        return $this->Adet;
    }
    /**
     * Set Adet value
     * @param int $adet
     * @return \StructType\GonderiParca
     */
    public function setAdet($adet = null)
    {
        // validation for constraint: int
        if (!is_null($adet) && !(is_int($adet) || ctype_digit($adet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adet, true), gettype($adet)), __LINE__);
        }
        $this->Adet = $adet;
        return $this;
    }
    /**
     * Get Icerik value
     * @return string|null
     */
    public function getIcerik()
    {
        return $this->Icerik;
    }
    /**
     * Set Icerik value
     * @param string $icerik
     * @return \StructType\GonderiParca
     */
    public function setIcerik($icerik = null)
    {
        // validation for constraint: string
        if (!is_null($icerik) && !is_string($icerik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($icerik, true), gettype($icerik)), __LINE__);
        }
        $this->Icerik = $icerik;
        return $this;
    }
    /**
     * Get ParcaBarkod value
     * @return string|null
     */
    public function getParcaBarkod()
    {
        return $this->ParcaBarkod;
    }
    /**
     * Set ParcaBarkod value
     * @param string $parcaBarkod
     * @return \StructType\GonderiParca
     */
    public function setParcaBarkod($parcaBarkod = null)
    {
        // validation for constraint: string
        if (!is_null($parcaBarkod) && !is_string($parcaBarkod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcaBarkod, true), gettype($parcaBarkod)), __LINE__);
        }
        $this->ParcaBarkod = $parcaBarkod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GonderiParca
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
