<?php

namespace EnumType;

/**
 * This class stands for YanitSekli EnumType
 * @subpackage Enumerations
 */
class YanitSekli
{
    /**
     * Constant for value 'TUMU'
     * @return string 'TUMU'
     */
    const VALUE_TUMU = 'TUMU';
    /**
     * Constant for value 'OLUMLU'
     * @return string 'OLUMLU'
     */
    const VALUE_OLUMLU = 'OLUMLU';
    /**
     * Constant for value 'OLUMSUZ'
     * @return string 'OLUMSUZ'
     */
    const VALUE_OLUMSUZ = 'OLUMSUZ';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TUMU
     * @uses self::VALUE_OLUMLU
     * @uses self::VALUE_OLUMSUZ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TUMU,
            self::VALUE_OLUMLU,
            self::VALUE_OLUMSUZ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
