<?php

namespace EnumType;

/**
 * This class stands for BayiType EnumType
 * @subpackage Enumerations
 */
class BayiType
{
    /**
     * Constant for value 'SAHIS'
     * @return string 'SAHIS'
     */
    const VALUE_SAHIS = 'SAHIS';
    /**
     * Constant for value 'FIRMA'
     * @return string 'FIRMA'
     */
    const VALUE_FIRMA = 'FIRMA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SAHIS
     * @uses self::VALUE_FIRMA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SAHIS,
            self::VALUE_FIRMA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
