<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://service.mngkargo.com.tr/musterikargosiparis/musterikargosiparis.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://service.mngkargo.com.tr/musterikargosiparis/musterikargosiparis.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Baglanti ServiceType
 */
$baglanti = new \ServiceType\Baglanti($options);
/**
 * Sample call for Baglanti_Test operation/method
 */
if ($baglanti->Baglanti_Test(new \StructType\Baglanti_Test()) !== false) {
    print_r($baglanti->getResult());
} else {
    print_r($baglanti->getLastError());
}
/**
 * Samples for Musteri ServiceType
 */
$musteri = new \ServiceType\Musteri($options);
/**
 * Sample call for MusteriSiparisKayit operation/method
 */
if ($musteri->MusteriSiparisKayit(new \StructType\MusteriSiparisKayit()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriSiparisIptal operation/method
 */
if ($musteri->MusteriSiparisIptal(new \StructType\MusteriSiparisIptal()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriBayiBilgileri operation/method
 */
if ($musteri->MusteriBayiBilgileri(new \StructType\MusteriBayiBilgileri()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriBayiIslem operation/method
 */
if ($musteri->MusteriBayiIslem(new \StructType\MusteriBayiIslem()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriOzelRapor operation/method
 */
if ($musteri->MusteriOzelRapor(new \StructType\MusteriOzelRapor()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriTeslimatIptalIstegi operation/method
 */
if ($musteri->MusteriTeslimatIptalIstegi(new \StructType\MusteriTeslimatIptalIstegi()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Samples for Siparis ServiceType
 */
$siparis = new \ServiceType\Siparis($options);
/**
 * Sample call for SiparisGirisiDetayli operation/method
 */
if ($siparis->SiparisGirisiDetayli(new \StructType\SiparisGirisiDetayli()) !== false) {
    print_r($siparis->getResult());
} else {
    print_r($siparis->getLastError());
}
/**
 * Sample call for SiparisGirisiDetayliV2 operation/method
 */
if ($siparis->SiparisGirisiDetayliV2(new \StructType\SiparisGirisiDetayliV2()) !== false) {
    print_r($siparis->getResult());
} else {
    print_r($siparis->getLastError());
}
/**
 * Sample call for SiparisGirisiDetayliV3 operation/method
 */
if ($siparis->SiparisGirisiDetayliV3(new \StructType\SiparisGirisiDetayliV3()) !== false) {
    print_r($siparis->getResult());
} else {
    print_r($siparis->getLastError());
}
/**
 * Sample call for SiparisGirisiDetayliV4 operation/method
 */
if ($siparis->SiparisGirisiDetayliV4(new \StructType\SiparisGirisiDetayliV4()) !== false) {
    print_r($siparis->getResult());
} else {
    print_r($siparis->getLastError());
}
/**
 * Sample call for SiparisAliciKayit operation/method
 */
if ($siparis->SiparisAliciKayit(new \StructType\SiparisAliciKayit()) !== false) {
    print_r($siparis->getResult());
} else {
    print_r($siparis->getLastError());
}
/**
 * Sample call for SiparisUpdateParcastring operation/method
 */
if ($siparis->SiparisUpdateParcastring(new \StructType\SiparisUpdateParcastring()) !== false) {
    print_r($siparis->getResult());
} else {
    print_r($siparis->getLastError());
}
/**
 * Sample call for SiparisUpdateParcastringV2 operation/method
 */
if ($siparis->SiparisUpdateParcastringV2(new \StructType\SiparisUpdateParcastringV2()) !== false) {
    print_r($siparis->getResult());
} else {
    print_r($siparis->getLastError());
}
/**
 * Samples for Fatura ServiceType
 */
$fatura = new \ServiceType\Fatura($options);
/**
 * Sample call for FaturaSiparisListesi operation/method
 */
if ($fatura->FaturaSiparisListesi(new \StructType\FaturaSiparisListesi()) !== false) {
    print_r($fatura->getResult());
} else {
    print_r($fatura->getLastError());
}
/**
 * Sample call for FaturaSiparisListesiByTarih operation/method
 */
if ($fatura->FaturaSiparisListesiByTarih(new \StructType\FaturaSiparisListesiByTarih()) !== false) {
    print_r($fatura->getResult());
} else {
    print_r($fatura->getLastError());
}
/**
 * Samples for Wms ServiceType
 */
$wms = new \ServiceType\Wms($options);
/**
 * Sample call for WmsIadeGirisi operation/method
 */
if ($wms->WmsIadeGirisi(new \StructType\WmsIadeGirisi()) !== false) {
    print_r($wms->getResult());
} else {
    print_r($wms->getLastError());
}
/**
 * Samples for Bayi ServiceType
 */
$bayi = new \ServiceType\Bayi($options);
/**
 * Sample call for BayiAdresiGecersiz operation/method
 */
if ($bayi->BayiAdresiGecersiz(new \StructType\BayiAdresiGecersiz()) !== false) {
    print_r($bayi->getResult());
} else {
    print_r($bayi->getLastError());
}
/**
 * Sample call for BayiIhbarGirisi operation/method
 */
if ($bayi->BayiIhbarGirisi(new \StructType\BayiIhbarGirisi()) !== false) {
    print_r($bayi->getResult());
} else {
    print_r($bayi->getLastError());
}
/**
 * Samples for Kargo ServiceType
 */
$kargo = new \ServiceType\Kargo($options);
/**
 * Sample call for KargoBilgileriByTarih operation/method
 */
if ($kargo->KargoBilgileriByTarih(new \StructType\KargoBilgileriByTarih()) !== false) {
    print_r($kargo->getResult());
} else {
    print_r($kargo->getLastError());
}
/**
 * Sample call for KargoBilgileriByReferans operation/method
 */
if ($kargo->KargoBilgileriByReferans(new \StructType\KargoBilgileriByReferans()) !== false) {
    print_r($kargo->getResult());
} else {
    print_r($kargo->getLastError());
}
/**
 * Sample call for KargoTakipByReferans operation/method
 */
if ($kargo->KargoTakipByReferans(new \StructType\KargoTakipByReferans()) !== false) {
    print_r($kargo->getResult());
} else {
    print_r($kargo->getLastError());
}
/**
 * Samples for Gonderi ServiceType
 */
$gonderi = new \ServiceType\Gonderi($options);
/**
 * Sample call for GonderiTeslimatProblemleri operation/method
 */
if ($gonderi->GonderiTeslimatProblemleri(new \StructType\GonderiTeslimatProblemleri()) !== false) {
    print_r($gonderi->getResult());
} else {
    print_r($gonderi->getLastError());
}
/**
 * Sample call for GonderiTeslimatProblemiIadeYaniti operation/method
 */
if ($gonderi->GonderiTeslimatProblemiIadeYaniti(new \StructType\GonderiTeslimatProblemiIadeYaniti()) !== false) {
    print_r($gonderi->getResult());
} else {
    print_r($gonderi->getLastError());
}
/**
 * Samples for MNGG ServiceType
 */
$mNGG = new \ServiceType\MNGG($options);
/**
 * Sample call for MNGGonderiBarkod operation/method
 */
if ($mNGG->MNGGonderiBarkod(new \StructType\MNGGonderiBarkod()) !== false) {
    print_r($mNGG->getResult());
} else {
    print_r($mNGG->getLastError());
}
/**
 * Samples for Tek ServiceType
 */
$tek = new \ServiceType\Tek($options);
/**
 * Sample call for TekBarkodGonderiIptali operation/method
 */
if ($tek->TekBarkodGonderiIptali(new \StructType\TekBarkodGonderiIptali()) !== false) {
    print_r($tek->getResult());
} else {
    print_r($tek->getLastError());
}
