<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kargo ServiceType
 * @subpackage Services
 */
class Kargo extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named KargoBilgileriByTarih
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KargoBilgileriByTarih $parameters
     * @return \StructType\KargoBilgileriByTarihResponse|bool
     */
    public function KargoBilgileriByTarih(\StructType\KargoBilgileriByTarih $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->KargoBilgileriByTarih($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named KargoBilgileriByReferans
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KargoBilgileriByReferans $parameters
     * @return \StructType\KargoBilgileriByReferansResponse|bool
     */
    public function KargoBilgileriByReferans(\StructType\KargoBilgileriByReferans $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->KargoBilgileriByReferans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named KargoTakipByReferans
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KargoTakipByReferans $parameters
     * @return \StructType\KargoTakipByReferansResponse|bool
     */
    public function KargoTakipByReferans(\StructType\KargoTakipByReferans $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->KargoTakipByReferans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KargoBilgileriByReferansResponse|\StructType\KargoBilgileriByTarihResponse|\StructType\KargoTakipByReferansResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
