<?php

namespace EnumType;

/**
 * This class stands for YanitlanmaDurumu EnumType
 * @subpackage Enumerations
 */
class YanitlanmaDurumu
{
    /**
     * Constant for value 'EVET'
     * @return string 'EVET'
     */
    const VALUE_EVET = 'EVET';
    /**
     * Constant for value 'HAYIR'
     * @return string 'HAYIR'
     */
    const VALUE_HAYIR = 'HAYIR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EVET
     * @uses self::VALUE_HAYIR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EVET,
            self::VALUE_HAYIR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
