<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Fatura ServiceType
 * @subpackage Services
 */
class Fatura extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FaturaSiparisListesi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FaturaSiparisListesi $parameters
     * @return \StructType\FaturaSiparisListesiResponse|bool
     */
    public function FaturaSiparisListesi(\StructType\FaturaSiparisListesi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FaturaSiparisListesi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FaturaSiparisListesiByTarih
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FaturaSiparisListesiByTarih $parameters
     * @return \StructType\FaturaSiparisListesiByTarihResponse|bool
     */
    public function FaturaSiparisListesiByTarih(\StructType\FaturaSiparisListesiByTarih $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FaturaSiparisListesiByTarih($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FaturaSiparisListesiByTarihResponse|\StructType\FaturaSiparisListesiResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
