<?php

namespace Straxus\FarfetchSDK\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save Service
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveGeoBrandPrices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\SaveGeoBrandPrices $parameters
     * @return \Straxus\FarfetchSDK\Model\SaveGeoBrandPricesResponse|bool
     */
    public function SaveGeoBrandPrices(\Straxus\FarfetchSDK\Model\SaveGeoBrandPrices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveGeoBrandPrices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Straxus\FarfetchSDK\Model\SaveGeoBrandPricesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
