<?php

namespace Straxus\FarfetchSDK\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mapp Service
 * @subpackage Services
 */
class Mapp extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MappDuplicates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\MappDuplicates $parameters
     * @return \Straxus\FarfetchSDK\Model\MappDuplicatesResponse|bool
     */
    public function MappDuplicates(\Straxus\FarfetchSDK\Model\MappDuplicates $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MappDuplicates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Straxus\FarfetchSDK\Model\MappDuplicatesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
