<?php

namespace Straxus\FarfetchSDK\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is Service
 * @subpackage Services
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named isBrandVisible
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\IsBrandVisible $parameters
     * @return \Straxus\FarfetchSDK\Model\IsBrandVisibleResponse|bool
     */
    public function isBrandVisible(\Straxus\FarfetchSDK\Model\IsBrandVisible $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->isBrandVisible($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IsBrandSeasonDesignerIdListBound
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\IsBrandSeasonDesignerIdListBound $parameters
     * @return \Straxus\FarfetchSDK\Model\IsBrandSeasonDesignerIdListBoundResponse|bool
     */
    public function IsBrandSeasonDesignerIdListBound(\Straxus\FarfetchSDK\Model\IsBrandSeasonDesignerIdListBound $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IsBrandSeasonDesignerIdListBound($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Straxus\FarfetchSDK\Model\IsBrandSeasonDesignerIdListBoundResponse|\Straxus\FarfetchSDK\Model\IsBrandVisibleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
