<?php

namespace Straxus\FarfetchSDK\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get Service
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetPossibleDuplicates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetPossibleDuplicates $parameters
     * @return \Straxus\FarfetchSDK\Model\GetPossibleDuplicatesResponse|bool
     */
    public function GetPossibleDuplicates(\Straxus\FarfetchSDK\Model\GetPossibleDuplicates $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPossibleDuplicates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBrandRegions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetBrandRegions $parameters
     * @return \Straxus\FarfetchSDK\Model\GetBrandRegionsResponse|bool
     */
    public function GetBrandRegions(\Straxus\FarfetchSDK\Model\GetBrandRegions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBrandRegions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetAllStock $parameters
     * @return \Straxus\FarfetchSDK\Model\GetAllStockResponse|bool
     */
    public function GetAllStock(\Straxus\FarfetchSDK\Model\GetAllStock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllStockWithStoreBarcodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetAllStockWithStoreBarcodes $parameters
     * @return \Straxus\FarfetchSDK\Model\GetAllStockWithStoreBarcodesResponse|bool
     */
    public function GetAllStockWithStoreBarcodes(\Straxus\FarfetchSDK\Model\GetAllStockWithStoreBarcodes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllStockWithStoreBarcodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBoxName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetBoxName $parameters
     * @return \Straxus\FarfetchSDK\Model\GetBoxNameResponse|bool
     */
    public function GetBoxName(\Straxus\FarfetchSDK\Model\GetBoxName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBoxName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBoxes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetBoxes $parameters
     * @return \Straxus\FarfetchSDK\Model\GetBoxesResponse|bool
     */
    public function GetBoxes(\Straxus\FarfetchSDK\Model\GetBoxes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBoxes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDefaultCountries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetDefaultCountries $parameters
     * @return \Straxus\FarfetchSDK\Model\GetDefaultCountriesResponse|bool
     */
    public function GetDefaultCountries(\Straxus\FarfetchSDK\Model\GetDefaultCountries $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDefaultCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetList $parameters
     * @return \Straxus\FarfetchSDK\Model\GetListResponse|bool
     */
    public function GetList(\Straxus\FarfetchSDK\Model\GetList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetColourTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetColourTypes $parameters
     * @return \Straxus\FarfetchSDK\Model\GetColourTypesResponse|bool
     */
    public function GetColourTypes(\Straxus\FarfetchSDK\Model\GetColourTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetColourTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetComposition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetComposition $parameters
     * @return \Straxus\FarfetchSDK\Model\GetCompositionResponse|bool
     */
    public function GetComposition(\Straxus\FarfetchSDK\Model\GetComposition $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetComposition($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMainView
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetMainView $parameters
     * @return \Straxus\FarfetchSDK\Model\GetMainViewResponse|bool
     */
    public function GetMainView(\Straxus\FarfetchSDK\Model\GetMainView $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMainView($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMeasures
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetMeasures $parameters
     * @return \Straxus\FarfetchSDK\Model\GetMeasuresResponse|bool
     */
    public function GetMeasures(\Straxus\FarfetchSDK\Model\GetMeasures $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMeasures($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPropValueNameById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetPropValueNameById $parameters
     * @return \Straxus\FarfetchSDK\Model\GetPropValueNameByIdResponse|bool
     */
    public function GetPropValueNameById(\Straxus\FarfetchSDK\Model\GetPropValueNameById $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPropValueNameById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPropValueIdByName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetPropValueIdByName $parameters
     * @return \Straxus\FarfetchSDK\Model\GetPropValueIdByNameResponse|bool
     */
    public function GetPropValueIdByName(\Straxus\FarfetchSDK\Model\GetPropValueIdByName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPropValueIdByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProperty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetProperty $parameters
     * @return \Straxus\FarfetchSDK\Model\GetPropertyResponse|bool
     */
    public function GetProperty(\Straxus\FarfetchSDK\Model\GetProperty $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProperty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSizeHelpId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetSizeHelpId $parameters
     * @return \Straxus\FarfetchSDK\Model\GetSizeHelpIdResponse|bool
     */
    public function GetSizeHelpId(\Straxus\FarfetchSDK\Model\GetSizeHelpId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSizeHelpId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSizes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetSizes $parameters
     * @return \Straxus\FarfetchSDK\Model\GetSizesResponse|bool
     */
    public function GetSizes(\Straxus\FarfetchSDK\Model\GetSizes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSizes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetStock $parameters
     * @return \Straxus\FarfetchSDK\Model\GetStockResponse|bool
     */
    public function GetStock(\Straxus\FarfetchSDK\Model\GetStock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStoreItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetStoreItems $parameters
     * @return \Straxus\FarfetchSDK\Model\GetStoreItemsResponse|bool
     */
    public function GetStoreItems(\Straxus\FarfetchSDK\Model\GetStoreItems $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStoreItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStorePrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetStorePrice $parameters
     * @return \Straxus\FarfetchSDK\Model\GetStorePriceResponse|bool
     */
    public function GetStorePrice(\Straxus\FarfetchSDK\Model\GetStorePrice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStorePrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebsiteDescription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetWebsiteDescription $parameters
     * @return \Straxus\FarfetchSDK\Model\GetWebsiteDescriptionResponse|bool
     */
    public function GetWebsiteDescription(\Straxus\FarfetchSDK\Model\GetWebsiteDescription $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWebsiteDescription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSKUandDesingerID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetSKUandDesingerID $parameters
     * @return \Straxus\FarfetchSDK\Model\GetSKUandDesingerIDResponse|bool
     */
    public function GetSKUandDesingerID(\Straxus\FarfetchSDK\Model\GetSKUandDesingerID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSKUandDesingerID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetParentItemId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetParentItemId $parameters
     * @return \Straxus\FarfetchSDK\Model\GetParentItemIdResponse|bool
     */
    public function GetParentItemId(\Straxus\FarfetchSDK\Model\GetParentItemId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetParentItemId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFFItemId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetFFItemId $parameters
     * @return \Straxus\FarfetchSDK\Model\GetFFItemIdResponse|bool
     */
    public function GetFFItemId(\Straxus\FarfetchSDK\Model\GetFFItemId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFFItemId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFFItemUrl
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetFFItemUrl $parameters
     * @return \Straxus\FarfetchSDK\Model\GetFFItemUrlResponse|bool
     */
    public function GetFFItemUrl(\Straxus\FarfetchSDK\Model\GetFFItemUrl $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFFItemUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGender
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetGender $parameters
     * @return \Straxus\FarfetchSDK\Model\GetGenderResponse|bool
     */
    public function GetGender(\Straxus\FarfetchSDK\Model\GetGender $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGender($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMaterialCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetMaterialCategory $parameters
     * @return \Straxus\FarfetchSDK\Model\GetMaterialCategoryResponse|bool
     */
    public function GetMaterialCategory(\Straxus\FarfetchSDK\Model\GetMaterialCategory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMaterialCategory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMaterial
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetMaterial $parameters
     * @return \Straxus\FarfetchSDK\Model\GetMaterialResponse|bool
     */
    public function GetMaterial(\Straxus\FarfetchSDK\Model\GetMaterial $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMaterial($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetCategories $parameters
     * @return \Straxus\FarfetchSDK\Model\GetCategoriesResponse|bool
     */
    public function GetCategories(\Straxus\FarfetchSDK\Model\GetCategories $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCategories($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSizeRangesFiltered
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetSizeRangesFiltered $parameters
     * @return \Straxus\FarfetchSDK\Model\GetSizeRangesFilteredResponse|bool
     */
    public function GetSizeRangesFiltered(\Straxus\FarfetchSDK\Model\GetSizeRangesFiltered $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSizeRangesFiltered($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSlots
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetSlots $parameters
     * @return \Straxus\FarfetchSDK\Model\GetSlotsResponse|bool
     */
    public function GetSlots(\Straxus\FarfetchSDK\Model\GetSlots $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSlots($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOpenSlots
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetOpenSlots $parameters
     * @return \Straxus\FarfetchSDK\Model\GetOpenSlotsResponse|bool
     */
    public function GetOpenSlots(\Straxus\FarfetchSDK\Model\GetOpenSlots $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOpenSlots($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSonId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetSonId $parameters
     * @return \Straxus\FarfetchSDK\Model\GetSonIdResponse|bool
     */
    public function GetSonId(\Straxus\FarfetchSDK\Model\GetSonId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSonId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSonIdForOrderManagement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetSonIdForOrderManagement $parameters
     * @return \Straxus\FarfetchSDK\Model\GetSonIdForOrderManagementResponse|bool
     */
    public function GetSonIdForOrderManagement(\Straxus\FarfetchSDK\Model\GetSonIdForOrderManagement $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSonIdForOrderManagement($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDesignerIdsForSeasonBrand
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetDesignerIdsForSeasonBrand $parameters
     * @return \Straxus\FarfetchSDK\Model\GetDesignerIdsForSeasonBrandResponse|bool
     */
    public function GetDesignerIdsForSeasonBrand(\Straxus\FarfetchSDK\Model\GetDesignerIdsForSeasonBrand $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDesignerIdsForSeasonBrand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllPictures
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetAllPictures $parameters
     * @return \Straxus\FarfetchSDK\Model\GetAllPicturesResponse|bool
     */
    public function GetAllPictures(\Straxus\FarfetchSDK\Model\GetAllPictures $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllPictures($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllPicturesByBarcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetAllPicturesByBarcode $parameters
     * @return \Straxus\FarfetchSDK\Model\GetAllPicturesByBarcodeResponse|bool
     */
    public function GetAllPicturesByBarcode(\Straxus\FarfetchSDK\Model\GetAllPicturesByBarcode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllPicturesByBarcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllSizeRangesInUse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetAllSizeRangesInUse $parameters
     * @return \Straxus\FarfetchSDK\Model\GetAllSizeRangesInUseResponse|bool
     */
    public function GetAllSizeRangesInUse(\Straxus\FarfetchSDK\Model\GetAllSizeRangesInUse $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllSizeRangesInUse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransportationProperties
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetTransportationProperties $parameters
     * @return \Straxus\FarfetchSDK\Model\GetTransportationPropertiesResponse|bool
     */
    public function GetTransportationProperties(\Straxus\FarfetchSDK\Model\GetTransportationProperties $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTransportationProperties($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductTransportationProperties
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\GetProductTransportationProperties $parameters
     * @return \Straxus\FarfetchSDK\Model\GetProductTransportationPropertiesResponse|bool
     */
    public function GetProductTransportationProperties(\Straxus\FarfetchSDK\Model\GetProductTransportationProperties $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProductTransportationProperties($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Straxus\FarfetchSDK\Model\GetAllPicturesByBarcodeResponse|\Straxus\FarfetchSDK\Model\GetAllPicturesResponse|\Straxus\FarfetchSDK\Model\GetAllSizeRangesInUseResponse|\Straxus\FarfetchSDK\Model\GetAllStockResponse|\Straxus\FarfetchSDK\Model\GetAllStockWithStoreBarcodesResponse|\Straxus\FarfetchSDK\Model\GetBoxesResponse|\Straxus\FarfetchSDK\Model\GetBoxNameResponse|\Straxus\FarfetchSDK\Model\GetBrandRegionsResponse|\Straxus\FarfetchSDK\Model\GetCategoriesResponse|\Straxus\FarfetchSDK\Model\GetColourTypesResponse|\Straxus\FarfetchSDK\Model\GetCompositionResponse|\Straxus\FarfetchSDK\Model\GetDefaultCountriesResponse|\Straxus\FarfetchSDK\Model\GetDesignerIdsForSeasonBrandResponse|\Straxus\FarfetchSDK\Model\GetFFItemIdResponse|\Straxus\FarfetchSDK\Model\GetFFItemUrlResponse|\Straxus\FarfetchSDK\Model\GetGenderResponse|\Straxus\FarfetchSDK\Model\GetListResponse|\Straxus\FarfetchSDK\Model\GetMainViewResponse|\Straxus\FarfetchSDK\Model\GetMaterialCategoryResponse|\Straxus\FarfetchSDK\Model\GetMaterialResponse|\Straxus\FarfetchSDK\Model\GetMeasuresResponse|\Straxus\FarfetchSDK\Model\GetOpenSlotsResponse|\Straxus\FarfetchSDK\Model\GetParentItemIdResponse|\Straxus\FarfetchSDK\Model\GetPossibleDuplicatesResponse|\Straxus\FarfetchSDK\Model\GetProductTransportationPropertiesResponse|\Straxus\FarfetchSDK\Model\GetPropertyResponse|\Straxus\FarfetchSDK\Model\GetPropValueIdByNameResponse|\Straxus\FarfetchSDK\Model\GetPropValueNameByIdResponse|\Straxus\FarfetchSDK\Model\GetSizeHelpIdResponse|\Straxus\FarfetchSDK\Model\GetSizeRangesFilteredResponse|\Straxus\FarfetchSDK\Model\GetSizesResponse|\Straxus\FarfetchSDK\Model\GetSKUandDesingerIDResponse|\Straxus\FarfetchSDK\Model\GetSlotsResponse|\Straxus\FarfetchSDK\Model\GetSonIdForOrderManagementResponse|\Straxus\FarfetchSDK\Model\GetSonIdResponse|\Straxus\FarfetchSDK\Model\GetStockResponse|\Straxus\FarfetchSDK\Model\GetStoreItemsResponse|\Straxus\FarfetchSDK\Model\GetStorePriceResponse|\Straxus\FarfetchSDK\Model\GetTransportationPropertiesResponse|\Straxus\FarfetchSDK\Model\GetWebsiteDescriptionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
