<?php

namespace Straxus\FarfetchSDK\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Associate Service
 * @subpackage Services
 */
class Associate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AssociateToChildProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\AssociateToChildProduct $parameters
     * @return \Straxus\FarfetchSDK\Model\AssociateToChildProductResponse|bool
     */
    public function AssociateToChildProduct(\Straxus\FarfetchSDK\Model\AssociateToChildProduct $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AssociateToChildProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AssociateProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\AssociateProduct $parameters
     * @return \Straxus\FarfetchSDK\Model\AssociateProductResponse|bool
     */
    public function AssociateProduct(\Straxus\FarfetchSDK\Model\AssociateProduct $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AssociateProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AssociateProductWithVat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\AssociateProductWithVat $parameters
     * @return \Straxus\FarfetchSDK\Model\AssociateProductWithVatResponse|bool
     */
    public function AssociateProductWithVat(\Straxus\FarfetchSDK\Model\AssociateProductWithVat $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AssociateProductWithVat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Straxus\FarfetchSDK\Model\AssociateProductResponse|\Straxus\FarfetchSDK\Model\AssociateProductWithVatResponse|\Straxus\FarfetchSDK\Model\AssociateToChildProductResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
