<?php

namespace Straxus\FarfetchSDK\Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportationProduct Model
 * @subpackage Structs
 */
class TransportationProduct extends AbstractStructBase
{
    /**
     * The ProductId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductId;
    /**
     * The Properties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Straxus\FarfetchSDK\Array\ArrayOfTransportationProperty
     */
    public $Properties;
    /**
     * Constructor method for TransportationProduct
     * @uses TransportationProduct::setProductId()
     * @uses TransportationProduct::setProperties()
     * @param int $productId
     * @param \Straxus\FarfetchSDK\Array\ArrayOfTransportationProperty $properties
     */
    public function __construct($productId = null, \Straxus\FarfetchSDK\Array\ArrayOfTransportationProperty $properties = null)
    {
        $this
            ->setProductId($productId)
            ->setProperties($properties);
    }
    /**
     * Get ProductId value
     * @return int
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \Straxus\FarfetchSDK\Model\TransportationProduct
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get Properties value
     * @return \Straxus\FarfetchSDK\Array\ArrayOfTransportationProperty|null
     */
    public function getProperties()
    {
        return $this->Properties;
    }
    /**
     * Set Properties value
     * @param \Straxus\FarfetchSDK\Array\ArrayOfTransportationProperty $properties
     * @return \Straxus\FarfetchSDK\Model\TransportationProduct
     */
    public function setProperties(\Straxus\FarfetchSDK\Array\ArrayOfTransportationProperty $properties = null)
    {
        $this->Properties = $properties;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Straxus\FarfetchSDK\Model\TransportationProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
