<?php

namespace Straxus\FarfetchSDK\Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertMaterials Model
 * @subpackage Structs
 */
class InsertMaterials extends AbstractStructBase
{
    /**
     * The articleId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $articleId;
    /**
     * The materialID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $materialID;
    /**
     * The compositionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $compositionType;
    /**
     * The percentage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $percentage;
    /**
     * The safeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * Constructor method for InsertMaterials
     * @uses InsertMaterials::setArticleId()
     * @uses InsertMaterials::setMaterialID()
     * @uses InsertMaterials::setCompositionType()
     * @uses InsertMaterials::setPercentage()
     * @uses InsertMaterials::setSafeKey()
     * @param int $articleId
     * @param int $materialID
     * @param int $compositionType
     * @param int $percentage
     * @param string $safeKey
     */
    public function __construct($articleId = null, $materialID = null, $compositionType = null, $percentage = null, $safeKey = null)
    {
        $this
            ->setArticleId($articleId)
            ->setMaterialID($materialID)
            ->setCompositionType($compositionType)
            ->setPercentage($percentage)
            ->setSafeKey($safeKey);
    }
    /**
     * Get articleId value
     * @return int
     */
    public function getArticleId()
    {
        return $this->articleId;
    }
    /**
     * Set articleId value
     * @param int $articleId
     * @return \Straxus\FarfetchSDK\Model\InsertMaterials
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: int
        if (!is_null($articleId) && !(is_int($articleId) || ctype_digit($articleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->articleId = $articleId;
        return $this;
    }
    /**
     * Get materialID value
     * @return int
     */
    public function getMaterialID()
    {
        return $this->materialID;
    }
    /**
     * Set materialID value
     * @param int $materialID
     * @return \Straxus\FarfetchSDK\Model\InsertMaterials
     */
    public function setMaterialID($materialID = null)
    {
        // validation for constraint: int
        if (!is_null($materialID) && !(is_int($materialID) || ctype_digit($materialID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($materialID, true), gettype($materialID)), __LINE__);
        }
        $this->materialID = $materialID;
        return $this;
    }
    /**
     * Get compositionType value
     * @return int
     */
    public function getCompositionType()
    {
        return $this->compositionType;
    }
    /**
     * Set compositionType value
     * @param int $compositionType
     * @return \Straxus\FarfetchSDK\Model\InsertMaterials
     */
    public function setCompositionType($compositionType = null)
    {
        // validation for constraint: int
        if (!is_null($compositionType) && !(is_int($compositionType) || ctype_digit($compositionType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($compositionType, true), gettype($compositionType)), __LINE__);
        }
        $this->compositionType = $compositionType;
        return $this;
    }
    /**
     * Get percentage value
     * @return int
     */
    public function getPercentage()
    {
        return $this->percentage;
    }
    /**
     * Set percentage value
     * @param int $percentage
     * @return \Straxus\FarfetchSDK\Model\InsertMaterials
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: int
        if (!is_null($percentage) && !(is_int($percentage) || ctype_digit($percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        $this->percentage = $percentage;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Straxus\FarfetchSDK\Model\InsertMaterials
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Straxus\FarfetchSDK\Model\InsertMaterials
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
