<?php

namespace Straxus\FarfetchSDK\Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFFItemId Model
 * @subpackage Structs
 */
class GetFFItemId extends AbstractStructBase
{
    /**
     * The storeid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $storeid;
    /**
     * The SafeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SafeKey;
    /**
     * The DesignerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DesignerId;
    /**
     * The SKU
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SKU;
    /**
     * Constructor method for GetFFItemId
     * @uses GetFFItemId::setStoreid()
     * @uses GetFFItemId::setSafeKey()
     * @uses GetFFItemId::setDesignerId()
     * @uses GetFFItemId::setSKU()
     * @param int $storeid
     * @param string $safeKey
     * @param string $designerId
     * @param string $sKU
     */
    public function __construct($storeid = null, $safeKey = null, $designerId = null, $sKU = null)
    {
        $this
            ->setStoreid($storeid)
            ->setSafeKey($safeKey)
            ->setDesignerId($designerId)
            ->setSKU($sKU);
    }
    /**
     * Get storeid value
     * @return int
     */
    public function getStoreid()
    {
        return $this->storeid;
    }
    /**
     * Set storeid value
     * @param int $storeid
     * @return \Straxus\FarfetchSDK\Model\GetFFItemId
     */
    public function setStoreid($storeid = null)
    {
        // validation for constraint: int
        if (!is_null($storeid) && !(is_int($storeid) || ctype_digit($storeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeid, true), gettype($storeid)), __LINE__);
        }
        $this->storeid = $storeid;
        return $this;
    }
    /**
     * Get SafeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->SafeKey;
    }
    /**
     * Set SafeKey value
     * @param string $safeKey
     * @return \Straxus\FarfetchSDK\Model\GetFFItemId
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->SafeKey = $safeKey;
        return $this;
    }
    /**
     * Get DesignerId value
     * @return string|null
     */
    public function getDesignerId()
    {
        return $this->DesignerId;
    }
    /**
     * Set DesignerId value
     * @param string $designerId
     * @return \Straxus\FarfetchSDK\Model\GetFFItemId
     */
    public function setDesignerId($designerId = null)
    {
        // validation for constraint: string
        if (!is_null($designerId) && !is_string($designerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($designerId, true), gettype($designerId)), __LINE__);
        }
        $this->DesignerId = $designerId;
        return $this;
    }
    /**
     * Get SKU value
     * @return string|null
     */
    public function getSKU()
    {
        return $this->SKU;
    }
    /**
     * Set SKU value
     * @param string $sKU
     * @return \Straxus\FarfetchSDK\Model\GetFFItemId
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sKU, true), gettype($sKU)), __LINE__);
        }
        $this->SKU = $sKU;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Straxus\FarfetchSDK\Model\GetFFItemId
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
