<?php

namespace Straxus\FarfetchSDK\Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDesignerIdsForSeasonBrand Model
 * @subpackage Structs
 */
class GetDesignerIdsForSeasonBrand extends AbstractStructBase
{
    /**
     * The brandId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $brandId;
    /**
     * The seasonId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $seasonId;
    /**
     * The safeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * Constructor method for GetDesignerIdsForSeasonBrand
     * @uses GetDesignerIdsForSeasonBrand::setBrandId()
     * @uses GetDesignerIdsForSeasonBrand::setSeasonId()
     * @uses GetDesignerIdsForSeasonBrand::setSafeKey()
     * @param int $brandId
     * @param int $seasonId
     * @param string $safeKey
     */
    public function __construct($brandId = null, $seasonId = null, $safeKey = null)
    {
        $this
            ->setBrandId($brandId)
            ->setSeasonId($seasonId)
            ->setSafeKey($safeKey);
    }
    /**
     * Get brandId value
     * @return int
     */
    public function getBrandId()
    {
        return $this->brandId;
    }
    /**
     * Set brandId value
     * @param int $brandId
     * @return \Straxus\FarfetchSDK\Model\GetDesignerIdsForSeasonBrand
     */
    public function setBrandId($brandId = null)
    {
        // validation for constraint: int
        if (!is_null($brandId) && !(is_int($brandId) || ctype_digit($brandId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brandId, true), gettype($brandId)), __LINE__);
        }
        $this->brandId = $brandId;
        return $this;
    }
    /**
     * Get seasonId value
     * @return int
     */
    public function getSeasonId()
    {
        return $this->seasonId;
    }
    /**
     * Set seasonId value
     * @param int $seasonId
     * @return \Straxus\FarfetchSDK\Model\GetDesignerIdsForSeasonBrand
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: int
        if (!is_null($seasonId) && !(is_int($seasonId) || ctype_digit($seasonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        $this->seasonId = $seasonId;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Straxus\FarfetchSDK\Model\GetDesignerIdsForSeasonBrand
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Straxus\FarfetchSDK\Model\GetDesignerIdsForSeasonBrand
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
