<?php

namespace Straxus\FarfetchSDK\Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoutiqueBarcodeResult Model
 * @subpackage Structs
 */
class BoutiqueBarcodeResult extends AbstractStructBase
{
    /**
     * The SizePosition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SizePosition;
    /**
     * The SizeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SizeValue;
    /**
     * The StoreBarcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StoreBarcode;
    /**
     * The FarfetchBarcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FarfetchBarcode;
    /**
     * Constructor method for BoutiqueBarcodeResult
     * @uses BoutiqueBarcodeResult::setSizePosition()
     * @uses BoutiqueBarcodeResult::setSizeValue()
     * @uses BoutiqueBarcodeResult::setStoreBarcode()
     * @uses BoutiqueBarcodeResult::setFarfetchBarcode()
     * @param int $sizePosition
     * @param string $sizeValue
     * @param string $storeBarcode
     * @param string $farfetchBarcode
     */
    public function __construct($sizePosition = null, $sizeValue = null, $storeBarcode = null, $farfetchBarcode = null)
    {
        $this
            ->setSizePosition($sizePosition)
            ->setSizeValue($sizeValue)
            ->setStoreBarcode($storeBarcode)
            ->setFarfetchBarcode($farfetchBarcode);
    }
    /**
     * Get SizePosition value
     * @return int
     */
    public function getSizePosition()
    {
        return $this->SizePosition;
    }
    /**
     * Set SizePosition value
     * @param int $sizePosition
     * @return \Straxus\FarfetchSDK\Model\BoutiqueBarcodeResult
     */
    public function setSizePosition($sizePosition = null)
    {
        // validation for constraint: int
        if (!is_null($sizePosition) && !(is_int($sizePosition) || ctype_digit($sizePosition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizePosition, true), gettype($sizePosition)), __LINE__);
        }
        $this->SizePosition = $sizePosition;
        return $this;
    }
    /**
     * Get SizeValue value
     * @return string|null
     */
    public function getSizeValue()
    {
        return $this->SizeValue;
    }
    /**
     * Set SizeValue value
     * @param string $sizeValue
     * @return \Straxus\FarfetchSDK\Model\BoutiqueBarcodeResult
     */
    public function setSizeValue($sizeValue = null)
    {
        // validation for constraint: string
        if (!is_null($sizeValue) && !is_string($sizeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizeValue, true), gettype($sizeValue)), __LINE__);
        }
        $this->SizeValue = $sizeValue;
        return $this;
    }
    /**
     * Get StoreBarcode value
     * @return string|null
     */
    public function getStoreBarcode()
    {
        return $this->StoreBarcode;
    }
    /**
     * Set StoreBarcode value
     * @param string $storeBarcode
     * @return \Straxus\FarfetchSDK\Model\BoutiqueBarcodeResult
     */
    public function setStoreBarcode($storeBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($storeBarcode) && !is_string($storeBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeBarcode, true), gettype($storeBarcode)), __LINE__);
        }
        $this->StoreBarcode = $storeBarcode;
        return $this;
    }
    /**
     * Get FarfetchBarcode value
     * @return string|null
     */
    public function getFarfetchBarcode()
    {
        return $this->FarfetchBarcode;
    }
    /**
     * Set FarfetchBarcode value
     * @param string $farfetchBarcode
     * @return \Straxus\FarfetchSDK\Model\BoutiqueBarcodeResult
     */
    public function setFarfetchBarcode($farfetchBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($farfetchBarcode) && !is_string($farfetchBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($farfetchBarcode, true), gettype($farfetchBarcode)), __LINE__);
        }
        $this->FarfetchBarcode = $farfetchBarcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Straxus\FarfetchSDK\Model\BoutiqueBarcodeResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
