<?php

namespace Straxus\FarfetchSDK\Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddDesignerIdToBrandSeasonList Model
 * @subpackage Structs
 */
class AddDesignerIdToBrandSeasonList extends AbstractStructBase
{
    /**
     * The brandid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $brandid;
    /**
     * The seasonId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $seasonId;
    /**
     * The designerIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Straxus\FarfetchSDK\Array\ArrayOfString
     */
    public $designerIds;
    /**
     * Constructor method for AddDesignerIdToBrandSeasonList
     * @uses AddDesignerIdToBrandSeasonList::setBrandid()
     * @uses AddDesignerIdToBrandSeasonList::setSeasonId()
     * @uses AddDesignerIdToBrandSeasonList::setDesignerIds()
     * @param int $brandid
     * @param int $seasonId
     * @param \Straxus\FarfetchSDK\Array\ArrayOfString $designerIds
     */
    public function __construct($brandid = null, $seasonId = null, \Straxus\FarfetchSDK\Array\ArrayOfString $designerIds = null)
    {
        $this
            ->setBrandid($brandid)
            ->setSeasonId($seasonId)
            ->setDesignerIds($designerIds);
    }
    /**
     * Get brandid value
     * @return int
     */
    public function getBrandid()
    {
        return $this->brandid;
    }
    /**
     * Set brandid value
     * @param int $brandid
     * @return \Straxus\FarfetchSDK\Model\AddDesignerIdToBrandSeasonList
     */
    public function setBrandid($brandid = null)
    {
        // validation for constraint: int
        if (!is_null($brandid) && !(is_int($brandid) || ctype_digit($brandid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brandid, true), gettype($brandid)), __LINE__);
        }
        $this->brandid = $brandid;
        return $this;
    }
    /**
     * Get seasonId value
     * @return int
     */
    public function getSeasonId()
    {
        return $this->seasonId;
    }
    /**
     * Set seasonId value
     * @param int $seasonId
     * @return \Straxus\FarfetchSDK\Model\AddDesignerIdToBrandSeasonList
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: int
        if (!is_null($seasonId) && !(is_int($seasonId) || ctype_digit($seasonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        $this->seasonId = $seasonId;
        return $this;
    }
    /**
     * Get designerIds value
     * @return \Straxus\FarfetchSDK\Array\ArrayOfString|null
     */
    public function getDesignerIds()
    {
        return $this->designerIds;
    }
    /**
     * Set designerIds value
     * @param \Straxus\FarfetchSDK\Array\ArrayOfString $designerIds
     * @return \Straxus\FarfetchSDK\Model\AddDesignerIdToBrandSeasonList
     */
    public function setDesignerIds(\Straxus\FarfetchSDK\Array\ArrayOfString $designerIds = null)
    {
        $this->designerIds = $designerIds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Straxus\FarfetchSDK\Model\AddDesignerIdToBrandSeasonList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
