<?php

namespace Straxus\FarfetchSDK\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Product Service
 * @subpackage Services
 */
class Product extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProductPriceUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\ProductPriceUpdate $parameters
     * @return \Straxus\FarfetchSDK\Model\ProductPriceUpdateResponse|bool
     */
    public function ProductPriceUpdate(\Straxus\FarfetchSDK\Model\ProductPriceUpdate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProductPriceUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Straxus\FarfetchSDK\Model\ProductPriceUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
