<?php

namespace Straxus\FarfetchSDK\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insert Service
 * @subpackage Services
 */
class Insert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InsertMaterials
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\InsertMaterials $parameters
     * @return \Straxus\FarfetchSDK\Model\InsertMaterialsResponse|bool
     */
    public function InsertMaterials(\Straxus\FarfetchSDK\Model\InsertMaterials $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertMaterials($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertSizesQuantity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\InsertSizesQuantity $parameters
     * @return \Straxus\FarfetchSDK\Model\InsertSizesQuantityResponse|bool
     */
    public function InsertSizesQuantity(\Straxus\FarfetchSDK\Model\InsertSizesQuantity $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertSizesQuantity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertStoreBarcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\InsertStoreBarcode $parameters
     * @return \Straxus\FarfetchSDK\Model\InsertStoreBarcodeResponse|bool
     */
    public function InsertStoreBarcode(\Straxus\FarfetchSDK\Model\InsertStoreBarcode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertStoreBarcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Straxus\FarfetchSDK\Model\InsertMaterialsResponse|\Straxus\FarfetchSDK\Model\InsertSizesQuantityResponse|\Straxus\FarfetchSDK\Model\InsertStoreBarcodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
