<?php

namespace Straxus\FarfetchSDK\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Getnd Service
 * @subpackage Services
 */
class Getnd extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Get2ndLevelCats
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\Get2ndLevelCats $parameters
     * @return \Straxus\FarfetchSDK\Model\Get2ndLevelCatsResponse|bool
     */
    public function Get2ndLevelCats(\Straxus\FarfetchSDK\Model\Get2ndLevelCats $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Get2ndLevelCats($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Straxus\FarfetchSDK\Model\Get2ndLevelCatsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
