<?php

namespace Straxus\FarfetchSDK\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Exist Service
 * @subpackage Services
 */
class Exist extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named existSKU
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\ExistSKU $parameters
     * @return \Straxus\FarfetchSDK\Model\ExistSKUResponse|bool
     */
    public function existSKU(\Straxus\FarfetchSDK\Model\ExistSKU $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->existSKU($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Straxus\FarfetchSDK\Model\ExistSKUResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
