<?php

namespace Straxus\FarfetchSDK\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create Service
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\CreateProduct $parameters
     * @return \Straxus\FarfetchSDK\Model\CreateProductResponse|bool
     */
    public function CreateProduct(\Straxus\FarfetchSDK\Model\CreateProduct $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateProductWithUuid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\CreateProductWithUuid $parameters
     * @return \Straxus\FarfetchSDK\Model\CreateProductWithUuidResponse|bool
     */
    public function CreateProductWithUuid(\Straxus\FarfetchSDK\Model\CreateProductWithUuid $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateProductWithUuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateProductWithUuidAndVat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\CreateProductWithUuidAndVat $parameters
     * @return \Straxus\FarfetchSDK\Model\CreateProductWithUuidAndVatResponse|bool
     */
    public function CreateProductWithUuidAndVat(\Straxus\FarfetchSDK\Model\CreateProductWithUuidAndVat $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateProductWithUuidAndVat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Straxus\FarfetchSDK\Model\CreateProductResponse|\Straxus\FarfetchSDK\Model\CreateProductWithUuidAndVatResponse|\Straxus\FarfetchSDK\Model\CreateProductWithUuidResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
