<?php

namespace Straxus\FarfetchSDK\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add Service
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddCountryOfOriginToItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\AddCountryOfOriginToItem $parameters
     * @return \Straxus\FarfetchSDK\Model\AddCountryOfOriginToItemResponse|bool
     */
    public function AddCountryOfOriginToItem(\Straxus\FarfetchSDK\Model\AddCountryOfOriginToItem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddCountryOfOriginToItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDesignerIdToBrandSeasonList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Straxus\FarfetchSDK\Model\AddDesignerIdToBrandSeasonList $parameters
     * @return \Straxus\FarfetchSDK\Model\AddDesignerIdToBrandSeasonListResponse|bool
     */
    public function AddDesignerIdToBrandSeasonList(\Straxus\FarfetchSDK\Model\AddDesignerIdToBrandSeasonList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDesignerIdToBrandSeasonList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Straxus\FarfetchSDK\Model\AddCountryOfOriginToItemResponse|\Straxus\FarfetchSDK\Model\AddDesignerIdToBrandSeasonListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
