<?php

namespace Straxus\FarfetchSDK\Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleBoutiqueBarcode Model
 * @subpackage Structs
 */
class SimpleBoutiqueBarcode extends AbstractStructBase
{
    /**
     * The SizePosition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SizePosition;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;
    /**
     * Constructor method for SimpleBoutiqueBarcode
     * @uses SimpleBoutiqueBarcode::setSizePosition()
     * @uses SimpleBoutiqueBarcode::setBarcode()
     * @param int $sizePosition
     * @param string $barcode
     */
    public function __construct($sizePosition = null, $barcode = null)
    {
        $this
            ->setSizePosition($sizePosition)
            ->setBarcode($barcode);
    }
    /**
     * Get SizePosition value
     * @return int
     */
    public function getSizePosition()
    {
        return $this->SizePosition;
    }
    /**
     * Set SizePosition value
     * @param int $sizePosition
     * @return \Straxus\FarfetchSDK\Model\SimpleBoutiqueBarcode
     */
    public function setSizePosition($sizePosition = null)
    {
        // validation for constraint: int
        if (!is_null($sizePosition) && !(is_int($sizePosition) || ctype_digit($sizePosition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizePosition, true), gettype($sizePosition)), __LINE__);
        }
        $this->SizePosition = $sizePosition;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \Straxus\FarfetchSDK\Model\SimpleBoutiqueBarcode
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Straxus\FarfetchSDK\Model\SimpleBoutiqueBarcode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
