<?php

namespace Straxus\FarfetchSDK\Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveGeoBrandPrices Model
 * @subpackage Structs
 */
class SaveGeoBrandPrices extends AbstractStructBase
{
    /**
     * The storeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $storeId;
    /**
     * The safeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * The brandPriceInputs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Straxus\FarfetchSDK\Array\ArrayOfGeoBrandPriceInput
     */
    public $brandPriceInputs;
    /**
     * Constructor method for SaveGeoBrandPrices
     * @uses SaveGeoBrandPrices::setStoreId()
     * @uses SaveGeoBrandPrices::setSafeKey()
     * @uses SaveGeoBrandPrices::setBrandPriceInputs()
     * @param int $storeId
     * @param string $safeKey
     * @param \Straxus\FarfetchSDK\Array\ArrayOfGeoBrandPriceInput $brandPriceInputs
     */
    public function __construct($storeId = null, $safeKey = null, \Straxus\FarfetchSDK\Array\ArrayOfGeoBrandPriceInput $brandPriceInputs = null)
    {
        $this
            ->setStoreId($storeId)
            ->setSafeKey($safeKey)
            ->setBrandPriceInputs($brandPriceInputs);
    }
    /**
     * Get storeId value
     * @return int
     */
    public function getStoreId()
    {
        return $this->storeId;
    }
    /**
     * Set storeId value
     * @param int $storeId
     * @return \Straxus\FarfetchSDK\Model\SaveGeoBrandPrices
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: int
        if (!is_null($storeId) && !(is_int($storeId) || ctype_digit($storeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        $this->storeId = $storeId;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Straxus\FarfetchSDK\Model\SaveGeoBrandPrices
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Get brandPriceInputs value
     * @return \Straxus\FarfetchSDK\Array\ArrayOfGeoBrandPriceInput|null
     */
    public function getBrandPriceInputs()
    {
        return $this->brandPriceInputs;
    }
    /**
     * Set brandPriceInputs value
     * @param \Straxus\FarfetchSDK\Array\ArrayOfGeoBrandPriceInput $brandPriceInputs
     * @return \Straxus\FarfetchSDK\Model\SaveGeoBrandPrices
     */
    public function setBrandPriceInputs(\Straxus\FarfetchSDK\Array\ArrayOfGeoBrandPriceInput $brandPriceInputs = null)
    {
        $this->brandPriceInputs = $brandPriceInputs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Straxus\FarfetchSDK\Model\SaveGeoBrandPrices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
