<?php

namespace Straxus\FarfetchSDK\Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStorePrice Model
 * @subpackage Structs
 */
class GetStorePrice extends AbstractStructBase
{
    /**
     * The storeid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $storeid;
    /**
     * The StorePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StorePrice;
    /**
     * The WebsitePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $WebsitePrice;
    /**
     * The ItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemID;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The safekey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safekey;
    /**
     * Constructor method for GetStorePrice
     * @uses GetStorePrice::setStoreid()
     * @uses GetStorePrice::setStorePrice()
     * @uses GetStorePrice::setWebsitePrice()
     * @uses GetStorePrice::setItemID()
     * @uses GetStorePrice::setCurrency()
     * @uses GetStorePrice::setSafekey()
     * @param int $storeid
     * @param float $storePrice
     * @param float $websitePrice
     * @param string $itemID
     * @param string $currency
     * @param string $safekey
     */
    public function __construct($storeid = null, $storePrice = null, $websitePrice = null, $itemID = null, $currency = null, $safekey = null)
    {
        $this
            ->setStoreid($storeid)
            ->setStorePrice($storePrice)
            ->setWebsitePrice($websitePrice)
            ->setItemID($itemID)
            ->setCurrency($currency)
            ->setSafekey($safekey);
    }
    /**
     * Get storeid value
     * @return int
     */
    public function getStoreid()
    {
        return $this->storeid;
    }
    /**
     * Set storeid value
     * @param int $storeid
     * @return \Straxus\FarfetchSDK\Model\GetStorePrice
     */
    public function setStoreid($storeid = null)
    {
        // validation for constraint: int
        if (!is_null($storeid) && !(is_int($storeid) || ctype_digit($storeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeid, true), gettype($storeid)), __LINE__);
        }
        $this->storeid = $storeid;
        return $this;
    }
    /**
     * Get StorePrice value
     * @return float
     */
    public function getStorePrice()
    {
        return $this->StorePrice;
    }
    /**
     * Set StorePrice value
     * @param float $storePrice
     * @return \Straxus\FarfetchSDK\Model\GetStorePrice
     */
    public function setStorePrice($storePrice = null)
    {
        // validation for constraint: float
        if (!is_null($storePrice) && !(is_float($storePrice) || is_numeric($storePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($storePrice, true), gettype($storePrice)), __LINE__);
        }
        $this->StorePrice = $storePrice;
        return $this;
    }
    /**
     * Get WebsitePrice value
     * @return float
     */
    public function getWebsitePrice()
    {
        return $this->WebsitePrice;
    }
    /**
     * Set WebsitePrice value
     * @param float $websitePrice
     * @return \Straxus\FarfetchSDK\Model\GetStorePrice
     */
    public function setWebsitePrice($websitePrice = null)
    {
        // validation for constraint: float
        if (!is_null($websitePrice) && !(is_float($websitePrice) || is_numeric($websitePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($websitePrice, true), gettype($websitePrice)), __LINE__);
        }
        $this->WebsitePrice = $websitePrice;
        return $this;
    }
    /**
     * Get ItemID value
     * @return string|null
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param string $itemID
     * @return \Straxus\FarfetchSDK\Model\GetStorePrice
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Straxus\FarfetchSDK\Model\GetStorePrice
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get safekey value
     * @return string|null
     */
    public function getSafekey()
    {
        return $this->safekey;
    }
    /**
     * Set safekey value
     * @param string $safekey
     * @return \Straxus\FarfetchSDK\Model\GetStorePrice
     */
    public function setSafekey($safekey = null)
    {
        // validation for constraint: string
        if (!is_null($safekey) && !is_string($safekey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safekey, true), gettype($safekey)), __LINE__);
        }
        $this->safekey = $safekey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Straxus\FarfetchSDK\Model\GetStorePrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
