<?php

namespace Straxus\FarfetchSDK\Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateProduct Model
 * @subpackage Structs
 */
class CreateProduct extends AbstractStructBase
{
    /**
     * The storeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $storeID;
    /**
     * The slotID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $slotID;
    /**
     * The seasonId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $seasonId;
    /**
     * The collectionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $collectionId;
    /**
     * The genderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $genderId;
    /**
     * The brandId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $brandId;
    /**
     * The itemCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $itemCategory;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $price;
    /**
     * The materialID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $materialID;
    /**
     * The boxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $boxID;
    /**
     * The escalaID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $escalaID;
    /**
     * The articleId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $articleId;
    /**
     * The SecLevelCatId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SecLevelCatId;
    /**
     * The sku
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * The style
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $style;
    /**
     * The colour
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $colour;
    /**
     * The itemName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $itemName;
    /**
     * The detail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $detail;
    /**
     * The itemDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $itemDescription;
    /**
     * The stylingNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $stylingNotes;
    /**
     * The designerInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $designerInfo;
    /**
     * The additionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $additionalInfo;
    /**
     * The fitAndSizeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fitAndSizeInfo;
    /**
     * The sizesQtd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sizesQtd;
    /**
     * The safeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * The transportationProperties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Straxus\FarfetchSDK\Array\ArrayOfInt
     */
    public $transportationProperties;
    /**
     * Constructor method for CreateProduct
     * @uses CreateProduct::setStoreID()
     * @uses CreateProduct::setSlotID()
     * @uses CreateProduct::setSeasonId()
     * @uses CreateProduct::setCollectionId()
     * @uses CreateProduct::setGenderId()
     * @uses CreateProduct::setBrandId()
     * @uses CreateProduct::setItemCategory()
     * @uses CreateProduct::setPrice()
     * @uses CreateProduct::setMaterialID()
     * @uses CreateProduct::setBoxID()
     * @uses CreateProduct::setEscalaID()
     * @uses CreateProduct::setArticleId()
     * @uses CreateProduct::setSecLevelCatId()
     * @uses CreateProduct::setSku()
     * @uses CreateProduct::setStyle()
     * @uses CreateProduct::setColour()
     * @uses CreateProduct::setItemName()
     * @uses CreateProduct::setDetail()
     * @uses CreateProduct::setItemDescription()
     * @uses CreateProduct::setStylingNotes()
     * @uses CreateProduct::setDesignerInfo()
     * @uses CreateProduct::setAdditionalInfo()
     * @uses CreateProduct::setFitAndSizeInfo()
     * @uses CreateProduct::setSizesQtd()
     * @uses CreateProduct::setSafeKey()
     * @uses CreateProduct::setTransportationProperties()
     * @param int $storeID
     * @param int $slotID
     * @param int $seasonId
     * @param int $collectionId
     * @param int $genderId
     * @param int $brandId
     * @param int $itemCategory
     * @param float $price
     * @param int $materialID
     * @param int $boxID
     * @param int $escalaID
     * @param int $articleId
     * @param int $secLevelCatId
     * @param string $sku
     * @param string $style
     * @param string $colour
     * @param string $itemName
     * @param string $detail
     * @param string $itemDescription
     * @param string $stylingNotes
     * @param string $designerInfo
     * @param string $additionalInfo
     * @param string $fitAndSizeInfo
     * @param string $sizesQtd
     * @param string $safeKey
     * @param \Straxus\FarfetchSDK\Array\ArrayOfInt $transportationProperties
     */
    public function __construct($storeID = null, $slotID = null, $seasonId = null, $collectionId = null, $genderId = null, $brandId = null, $itemCategory = null, $price = null, $materialID = null, $boxID = null, $escalaID = null, $articleId = null, $secLevelCatId = null, $sku = null, $style = null, $colour = null, $itemName = null, $detail = null, $itemDescription = null, $stylingNotes = null, $designerInfo = null, $additionalInfo = null, $fitAndSizeInfo = null, $sizesQtd = null, $safeKey = null, \Straxus\FarfetchSDK\Array\ArrayOfInt $transportationProperties = null)
    {
        $this
            ->setStoreID($storeID)
            ->setSlotID($slotID)
            ->setSeasonId($seasonId)
            ->setCollectionId($collectionId)
            ->setGenderId($genderId)
            ->setBrandId($brandId)
            ->setItemCategory($itemCategory)
            ->setPrice($price)
            ->setMaterialID($materialID)
            ->setBoxID($boxID)
            ->setEscalaID($escalaID)
            ->setArticleId($articleId)
            ->setSecLevelCatId($secLevelCatId)
            ->setSku($sku)
            ->setStyle($style)
            ->setColour($colour)
            ->setItemName($itemName)
            ->setDetail($detail)
            ->setItemDescription($itemDescription)
            ->setStylingNotes($stylingNotes)
            ->setDesignerInfo($designerInfo)
            ->setAdditionalInfo($additionalInfo)
            ->setFitAndSizeInfo($fitAndSizeInfo)
            ->setSizesQtd($sizesQtd)
            ->setSafeKey($safeKey)
            ->setTransportationProperties($transportationProperties);
    }
    /**
     * Get storeID value
     * @return int
     */
    public function getStoreID()
    {
        return $this->storeID;
    }
    /**
     * Set storeID value
     * @param int $storeID
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setStoreID($storeID = null)
    {
        // validation for constraint: int
        if (!is_null($storeID) && !(is_int($storeID) || ctype_digit($storeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeID, true), gettype($storeID)), __LINE__);
        }
        $this->storeID = $storeID;
        return $this;
    }
    /**
     * Get slotID value
     * @return int
     */
    public function getSlotID()
    {
        return $this->slotID;
    }
    /**
     * Set slotID value
     * @param int $slotID
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setSlotID($slotID = null)
    {
        // validation for constraint: int
        if (!is_null($slotID) && !(is_int($slotID) || ctype_digit($slotID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($slotID, true), gettype($slotID)), __LINE__);
        }
        $this->slotID = $slotID;
        return $this;
    }
    /**
     * Get seasonId value
     * @return int
     */
    public function getSeasonId()
    {
        return $this->seasonId;
    }
    /**
     * Set seasonId value
     * @param int $seasonId
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: int
        if (!is_null($seasonId) && !(is_int($seasonId) || ctype_digit($seasonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        $this->seasonId = $seasonId;
        return $this;
    }
    /**
     * Get collectionId value
     * @return int
     */
    public function getCollectionId()
    {
        return $this->collectionId;
    }
    /**
     * Set collectionId value
     * @param int $collectionId
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setCollectionId($collectionId = null)
    {
        // validation for constraint: int
        if (!is_null($collectionId) && !(is_int($collectionId) || ctype_digit($collectionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($collectionId, true), gettype($collectionId)), __LINE__);
        }
        $this->collectionId = $collectionId;
        return $this;
    }
    /**
     * Get genderId value
     * @return int
     */
    public function getGenderId()
    {
        return $this->genderId;
    }
    /**
     * Set genderId value
     * @param int $genderId
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setGenderId($genderId = null)
    {
        // validation for constraint: int
        if (!is_null($genderId) && !(is_int($genderId) || ctype_digit($genderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($genderId, true), gettype($genderId)), __LINE__);
        }
        $this->genderId = $genderId;
        return $this;
    }
    /**
     * Get brandId value
     * @return int
     */
    public function getBrandId()
    {
        return $this->brandId;
    }
    /**
     * Set brandId value
     * @param int $brandId
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setBrandId($brandId = null)
    {
        // validation for constraint: int
        if (!is_null($brandId) && !(is_int($brandId) || ctype_digit($brandId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brandId, true), gettype($brandId)), __LINE__);
        }
        $this->brandId = $brandId;
        return $this;
    }
    /**
     * Get itemCategory value
     * @return int
     */
    public function getItemCategory()
    {
        return $this->itemCategory;
    }
    /**
     * Set itemCategory value
     * @param int $itemCategory
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setItemCategory($itemCategory = null)
    {
        // validation for constraint: int
        if (!is_null($itemCategory) && !(is_int($itemCategory) || ctype_digit($itemCategory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemCategory, true), gettype($itemCategory)), __LINE__);
        }
        $this->itemCategory = $itemCategory;
        return $this;
    }
    /**
     * Get price value
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get materialID value
     * @return int
     */
    public function getMaterialID()
    {
        return $this->materialID;
    }
    /**
     * Set materialID value
     * @param int $materialID
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setMaterialID($materialID = null)
    {
        // validation for constraint: int
        if (!is_null($materialID) && !(is_int($materialID) || ctype_digit($materialID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($materialID, true), gettype($materialID)), __LINE__);
        }
        $this->materialID = $materialID;
        return $this;
    }
    /**
     * Get boxID value
     * @return int
     */
    public function getBoxID()
    {
        return $this->boxID;
    }
    /**
     * Set boxID value
     * @param int $boxID
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setBoxID($boxID = null)
    {
        // validation for constraint: int
        if (!is_null($boxID) && !(is_int($boxID) || ctype_digit($boxID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boxID, true), gettype($boxID)), __LINE__);
        }
        $this->boxID = $boxID;
        return $this;
    }
    /**
     * Get escalaID value
     * @return int
     */
    public function getEscalaID()
    {
        return $this->escalaID;
    }
    /**
     * Set escalaID value
     * @param int $escalaID
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setEscalaID($escalaID = null)
    {
        // validation for constraint: int
        if (!is_null($escalaID) && !(is_int($escalaID) || ctype_digit($escalaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($escalaID, true), gettype($escalaID)), __LINE__);
        }
        $this->escalaID = $escalaID;
        return $this;
    }
    /**
     * Get articleId value
     * @return int
     */
    public function getArticleId()
    {
        return $this->articleId;
    }
    /**
     * Set articleId value
     * @param int $articleId
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: int
        if (!is_null($articleId) && !(is_int($articleId) || ctype_digit($articleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->articleId = $articleId;
        return $this;
    }
    /**
     * Get SecLevelCatId value
     * @return int
     */
    public function getSecLevelCatId()
    {
        return $this->SecLevelCatId;
    }
    /**
     * Set SecLevelCatId value
     * @param int $secLevelCatId
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setSecLevelCatId($secLevelCatId = null)
    {
        // validation for constraint: int
        if (!is_null($secLevelCatId) && !(is_int($secLevelCatId) || ctype_digit($secLevelCatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($secLevelCatId, true), gettype($secLevelCatId)), __LINE__);
        }
        $this->SecLevelCatId = $secLevelCatId;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sku, true), gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get style value
     * @return string|null
     */
    public function getStyle()
    {
        return $this->style;
    }
    /**
     * Set style value
     * @param string $style
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setStyle($style = null)
    {
        // validation for constraint: string
        if (!is_null($style) && !is_string($style)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($style, true), gettype($style)), __LINE__);
        }
        $this->style = $style;
        return $this;
    }
    /**
     * Get colour value
     * @return string|null
     */
    public function getColour()
    {
        return $this->colour;
    }
    /**
     * Set colour value
     * @param string $colour
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setColour($colour = null)
    {
        // validation for constraint: string
        if (!is_null($colour) && !is_string($colour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colour, true), gettype($colour)), __LINE__);
        }
        $this->colour = $colour;
        return $this;
    }
    /**
     * Get itemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->itemName;
    }
    /**
     * Set itemName value
     * @param string $itemName
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->itemName = $itemName;
        return $this;
    }
    /**
     * Get detail value
     * @return string|null
     */
    public function getDetail()
    {
        return $this->detail;
    }
    /**
     * Set detail value
     * @param string $detail
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: string
        if (!is_null($detail) && !is_string($detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detail, true), gettype($detail)), __LINE__);
        }
        $this->detail = $detail;
        return $this;
    }
    /**
     * Get itemDescription value
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->itemDescription;
    }
    /**
     * Set itemDescription value
     * @param string $itemDescription
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        $this->itemDescription = $itemDescription;
        return $this;
    }
    /**
     * Get stylingNotes value
     * @return string|null
     */
    public function getStylingNotes()
    {
        return $this->stylingNotes;
    }
    /**
     * Set stylingNotes value
     * @param string $stylingNotes
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setStylingNotes($stylingNotes = null)
    {
        // validation for constraint: string
        if (!is_null($stylingNotes) && !is_string($stylingNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stylingNotes, true), gettype($stylingNotes)), __LINE__);
        }
        $this->stylingNotes = $stylingNotes;
        return $this;
    }
    /**
     * Get designerInfo value
     * @return string|null
     */
    public function getDesignerInfo()
    {
        return $this->designerInfo;
    }
    /**
     * Set designerInfo value
     * @param string $designerInfo
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setDesignerInfo($designerInfo = null)
    {
        // validation for constraint: string
        if (!is_null($designerInfo) && !is_string($designerInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($designerInfo, true), gettype($designerInfo)), __LINE__);
        }
        $this->designerInfo = $designerInfo;
        return $this;
    }
    /**
     * Get additionalInfo value
     * @return string|null
     */
    public function getAdditionalInfo()
    {
        return $this->additionalInfo;
    }
    /**
     * Set additionalInfo value
     * @param string $additionalInfo
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInfo) && !is_string($additionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInfo, true), gettype($additionalInfo)), __LINE__);
        }
        $this->additionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get fitAndSizeInfo value
     * @return string|null
     */
    public function getFitAndSizeInfo()
    {
        return $this->fitAndSizeInfo;
    }
    /**
     * Set fitAndSizeInfo value
     * @param string $fitAndSizeInfo
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setFitAndSizeInfo($fitAndSizeInfo = null)
    {
        // validation for constraint: string
        if (!is_null($fitAndSizeInfo) && !is_string($fitAndSizeInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fitAndSizeInfo, true), gettype($fitAndSizeInfo)), __LINE__);
        }
        $this->fitAndSizeInfo = $fitAndSizeInfo;
        return $this;
    }
    /**
     * Get sizesQtd value
     * @return string|null
     */
    public function getSizesQtd()
    {
        return $this->sizesQtd;
    }
    /**
     * Set sizesQtd value
     * @param string $sizesQtd
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setSizesQtd($sizesQtd = null)
    {
        // validation for constraint: string
        if (!is_null($sizesQtd) && !is_string($sizesQtd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizesQtd, true), gettype($sizesQtd)), __LINE__);
        }
        $this->sizesQtd = $sizesQtd;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Get transportationProperties value
     * @return \Straxus\FarfetchSDK\Array\ArrayOfInt|null
     */
    public function getTransportationProperties()
    {
        return $this->transportationProperties;
    }
    /**
     * Set transportationProperties value
     * @param \Straxus\FarfetchSDK\Array\ArrayOfInt $transportationProperties
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public function setTransportationProperties(\Straxus\FarfetchSDK\Array\ArrayOfInt $transportationProperties = null)
    {
        $this->transportationProperties = $transportationProperties;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Straxus\FarfetchSDK\Model\CreateProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
