<?php

namespace Straxus\FarfetchSDK\Model;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociateToChildProduct Model
 * @subpackage Structs
 */
class AssociateToChildProduct extends AbstractStructBase
{
    /**
     * The storeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $storeId;
    /**
     * The itemId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $itemId;
    /**
     * The boutiquePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $boutiquePrice;
    /**
     * The safeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * The sku
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * The barcodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Straxus\FarfetchSDK\Array\ArrayOfSimpleBoutiqueBarcode
     */
    public $barcodes;
    /**
     * Constructor method for AssociateToChildProduct
     * @uses AssociateToChildProduct::setStoreId()
     * @uses AssociateToChildProduct::setItemId()
     * @uses AssociateToChildProduct::setBoutiquePrice()
     * @uses AssociateToChildProduct::setSafeKey()
     * @uses AssociateToChildProduct::setSku()
     * @uses AssociateToChildProduct::setBarcodes()
     * @param int $storeId
     * @param int $itemId
     * @param float $boutiquePrice
     * @param string $safeKey
     * @param string $sku
     * @param \Straxus\FarfetchSDK\Array\ArrayOfSimpleBoutiqueBarcode $barcodes
     */
    public function __construct($storeId = null, $itemId = null, $boutiquePrice = null, $safeKey = null, $sku = null, \Straxus\FarfetchSDK\Array\ArrayOfSimpleBoutiqueBarcode $barcodes = null)
    {
        $this
            ->setStoreId($storeId)
            ->setItemId($itemId)
            ->setBoutiquePrice($boutiquePrice)
            ->setSafeKey($safeKey)
            ->setSku($sku)
            ->setBarcodes($barcodes);
    }
    /**
     * Get storeId value
     * @return int
     */
    public function getStoreId()
    {
        return $this->storeId;
    }
    /**
     * Set storeId value
     * @param int $storeId
     * @return \Straxus\FarfetchSDK\Model\AssociateToChildProduct
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: int
        if (!is_null($storeId) && !(is_int($storeId) || ctype_digit($storeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        $this->storeId = $storeId;
        return $this;
    }
    /**
     * Get itemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param int $itemId
     * @return \Straxus\FarfetchSDK\Model\AssociateToChildProduct
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get boutiquePrice value
     * @return float
     */
    public function getBoutiquePrice()
    {
        return $this->boutiquePrice;
    }
    /**
     * Set boutiquePrice value
     * @param float $boutiquePrice
     * @return \Straxus\FarfetchSDK\Model\AssociateToChildProduct
     */
    public function setBoutiquePrice($boutiquePrice = null)
    {
        // validation for constraint: float
        if (!is_null($boutiquePrice) && !(is_float($boutiquePrice) || is_numeric($boutiquePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($boutiquePrice, true), gettype($boutiquePrice)), __LINE__);
        }
        $this->boutiquePrice = $boutiquePrice;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Straxus\FarfetchSDK\Model\AssociateToChildProduct
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \Straxus\FarfetchSDK\Model\AssociateToChildProduct
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sku, true), gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get barcodes value
     * @return \Straxus\FarfetchSDK\Array\ArrayOfSimpleBoutiqueBarcode|null
     */
    public function getBarcodes()
    {
        return $this->barcodes;
    }
    /**
     * Set barcodes value
     * @param \Straxus\FarfetchSDK\Array\ArrayOfSimpleBoutiqueBarcode $barcodes
     * @return \Straxus\FarfetchSDK\Model\AssociateToChildProduct
     */
    public function setBarcodes(\Straxus\FarfetchSDK\Array\ArrayOfSimpleBoutiqueBarcode $barcodes = null)
    {
        $this->barcodes = $barcodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Straxus\FarfetchSDK\Model\AssociateToChildProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
