<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceIndicativeCustomsValues StructType
 * Meta information extracted from the WSDL
 * - documentation: Customs Invoice Indicative Customs Values
 * @subpackage Structs
 */
class InvoiceIndicativeCustomsValues extends AbstractStructBase
{
    /**
     * The ImportCustomsDutyValue
     * Meta information extracted from the WSDL
     * - documentation: Customs Invoice Indicative Customs Duty value
     * - base: xsd:decimal
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var float
     */
    public $ImportCustomsDutyValue;
    /**
     * The ImportTaxesValue
     * Meta information extracted from the WSDL
     * - documentation: Customs Invoice Indicative Import Taxes value
     * - base: xsd:decimal
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var float
     */
    public $ImportTaxesValue;
    /**
     * Constructor method for InvoiceIndicativeCustomsValues
     * @uses InvoiceIndicativeCustomsValues::setImportCustomsDutyValue()
     * @uses InvoiceIndicativeCustomsValues::setImportTaxesValue()
     * @param float $importCustomsDutyValue
     * @param float $importTaxesValue
     */
    public function __construct($importCustomsDutyValue = null, $importTaxesValue = null)
    {
        $this
            ->setImportCustomsDutyValue($importCustomsDutyValue)
            ->setImportTaxesValue($importTaxesValue);
    }
    /**
     * Get ImportCustomsDutyValue value
     * @return float|null
     */
    public function getImportCustomsDutyValue()
    {
        return $this->ImportCustomsDutyValue;
    }
    /**
     * Set ImportCustomsDutyValue value
     * @param float $importCustomsDutyValue
     * @return \App\Delivery\Dhl\StructType\InvoiceIndicativeCustomsValues
     */
    public function setImportCustomsDutyValue($importCustomsDutyValue = null)
    {
        // validation for constraint: float
        if (!is_null($importCustomsDutyValue) && !(is_float($importCustomsDutyValue) || is_numeric($importCustomsDutyValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importCustomsDutyValue, true), gettype($importCustomsDutyValue)), __LINE__);
        }
        $this->ImportCustomsDutyValue = $importCustomsDutyValue;
        return $this;
    }
    /**
     * Get ImportTaxesValue value
     * @return float|null
     */
    public function getImportTaxesValue()
    {
        return $this->ImportTaxesValue;
    }
    /**
     * Set ImportTaxesValue value
     * @param float $importTaxesValue
     * @return \App\Delivery\Dhl\StructType\InvoiceIndicativeCustomsValues
     */
    public function setImportTaxesValue($importTaxesValue = null)
    {
        // validation for constraint: float
        if (!is_null($importTaxesValue) && !(is_float($importTaxesValue) || is_numeric($importTaxesValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importTaxesValue, true), gettype($importTaxesValue)), __LINE__);
        }
        $this->ImportTaxesValue = $importTaxesValue;
        return $this;
    }
}
