<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportLineItemType StructType
 * @subpackage Structs
 */
class ExportLineItemType extends AbstractStructBase
{
    /**
     * The CommodityCode
     * Meta information extracted from the WSDL
     * - documentation: Export Commodity code for the shipment at item line level | Commodity codes for shipment type
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $CommodityCode;
    /**
     * The ImportCommodityCode
     * Meta information extracted from the WSDL
     * - documentation: Import Commodity code for the shipment at item line level | Commodity codes for shipment type
     * - base: xsd:string
     * - maxLength: 18
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $ImportCommodityCode;
    /**
     * The ExportReasonType
     * Meta information extracted from the WSDL
     * - documentation: Reason for Export. Possible values: PERMANENT TEMPORARY RETURN USED_EXHIBITION_GOODS_TO_ORIGIN INTERCOMPANY_USE COMMERCIAL_PURPOSE_OR_SALE PERSONAL_BELONGINGS_OR_PERSONAL_USE SAMPLE GIFT RETURN_TO_ORIGIN WARRANTY_REPLACEMENT
     * DIPLOMATIC_GOODS DEFENCE_MATERIAL | Export reason code (Permanent, Temporary,Return)
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $ExportReasonType;
    /**
     * The ItemNumber
     * Meta information extracted from the WSDL
     * - documentation: Serial number for the items | Export line item number
     * - base: xsd:positiveInteger
     * - maxInclusive: 999
     * - minInclusive: 1
     * @var int
     */
    public $ItemNumber;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Number of pieces of a particular line item
     * - base: xsd:integer
     * - maxInclusive: 1000000000
     * - minInclusive: 1
     * @var int
     */
    public $Quantity;
    /**
     * The QuantityUnitOfMeasurement
     * Meta information extracted from the WSDL
     * - documentation: Quantity unit of measurement used in custom invoice purposes. UOM Description BOX Boxes 2GM Centigram 2M Centimeters 2M3 Cubic Centimeters 3M3 Cubic Feet M3 Cubic Meters DPR Dozen Pairs DOZ Dozen 2NO Each PCS Pieces GM Grams GRS
     * Gross KG Kilograms L Liters M Meters 3GM Milligrams 3L Milliliters X No Unit Required NO Number 2KG Ounces PRS Pairs 2L Gallons 3KG Pounds CM2 Square Centimeters 2M2 Square Feet 3M2 Square Inches M2 Square Meters 4M2 Square Yards 3M Yards Please
     * refer to the DHL EXPRESS - MyDHL API - SOAP Developer Guide for valid enumeration values. For more information please contact your local DHL Express API representative.
     * - base: xsd:string
     * - maxLength: 8
     * @var string
     */
    public $QuantityUnitOfMeasurement;
    /**
     * The ItemDescription
     * Meta information extracted from the WSDL
     * - documentation: The description of the line item | Export line item description
     * - base: xsd:string
     * - maxLength: 512
     * @var string
     */
    public $ItemDescription;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - documentation: Monetary value of each line item
     * - base: xsd:decimal
     * - whiteSpace: collapse
     * @var float
     */
    public $UnitPrice;
    /**
     * The NetWeight
     * Meta information extracted from the WSDL
     * - documentation: Net weight of the line item
     * - base: xsd:decimal
     * - whiteSpace: collapse
     * @var float
     */
    public $NetWeight;
    /**
     * The GrossWeight
     * Meta information extracted from the WSDL
     * - documentation: Gross weight of the line item
     * - base: xsd:decimal
     * - whiteSpace: collapse
     * @var float
     */
    public $GrossWeight;
    /**
     * The ManufacturingCountryCode
     * Meta information extracted from the WSDL
     * - documentation: Manufacturing ISO country code | ISO 2 character codes of the Shipper/Recipient country
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ManufacturingCountryCode;
    /**
     * The TaxesPaid
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $TaxesPaid;
    /**
     * The AdditionalInformation
     * Meta information extracted from the WSDL
     * - documentation: Customs Invoice's Export Declaration Line Item's Additional Information Texts. This will be printed in Customs Invoice's template COMMERCIAL_INVOICE_04 or COMMERCIAL_INVOICE_P_10 or COMMERCIAL_INVOICE_L_10
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\AdditionalInformation
     */
    public $AdditionalInformation;
    /**
     * The LicenseNumber
     * Meta information extracted from the WSDL
     * - documentation: Shipper export license to be used for Commercial Invoice template COMMERCIAL_INVOICE_07 printing purpose only. | Export license number
     * - base: xsd:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $LicenseNumber;
    /**
     * The ItemReferences
     * Meta information extracted from the WSDL
     * - documentation: Invoice line item level reference numbers and their type codes.
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\ItemReferences
     */
    public $ItemReferences;
    /**
     * The CustomsPaperworks
     * Meta information extracted from the WSDL
     * - documentation: Invoice line item level Customs documents and their type codes
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\CustomsPaperworks
     */
    public $CustomsPaperworks;
    /**
     * Constructor method for ExportLineItemType
     * @uses ExportLineItemType::setCommodityCode()
     * @uses ExportLineItemType::setImportCommodityCode()
     * @uses ExportLineItemType::setExportReasonType()
     * @uses ExportLineItemType::setItemNumber()
     * @uses ExportLineItemType::setQuantity()
     * @uses ExportLineItemType::setQuantityUnitOfMeasurement()
     * @uses ExportLineItemType::setItemDescription()
     * @uses ExportLineItemType::setUnitPrice()
     * @uses ExportLineItemType::setNetWeight()
     * @uses ExportLineItemType::setGrossWeight()
     * @uses ExportLineItemType::setManufacturingCountryCode()
     * @uses ExportLineItemType::setTaxesPaid()
     * @uses ExportLineItemType::setAdditionalInformation()
     * @uses ExportLineItemType::setLicenseNumber()
     * @uses ExportLineItemType::setItemReferences()
     * @uses ExportLineItemType::setCustomsPaperworks()
     * @param string $commodityCode
     * @param string $importCommodityCode
     * @param string $exportReasonType
     * @param int $itemNumber
     * @param int $quantity
     * @param string $quantityUnitOfMeasurement
     * @param string $itemDescription
     * @param float $unitPrice
     * @param float $netWeight
     * @param float $grossWeight
     * @param string $manufacturingCountryCode
     * @param string $taxesPaid
     * @param \App\Delivery\Dhl\StructType\AdditionalInformation $additionalInformation
     * @param string $licenseNumber
     * @param \App\Delivery\Dhl\StructType\ItemReferences $itemReferences
     * @param \App\Delivery\Dhl\StructType\CustomsPaperworks $customsPaperworks
     */
    public function __construct($commodityCode = null, $importCommodityCode = null, $exportReasonType = null, $itemNumber = null, $quantity = null, $quantityUnitOfMeasurement = null, $itemDescription = null, $unitPrice = null, $netWeight = null, $grossWeight = null, $manufacturingCountryCode = null, $taxesPaid = 'N', \App\Delivery\Dhl\StructType\AdditionalInformation $additionalInformation = null, $licenseNumber = null, \App\Delivery\Dhl\StructType\ItemReferences $itemReferences = null, \App\Delivery\Dhl\StructType\CustomsPaperworks $customsPaperworks = null)
    {
        $this
            ->setCommodityCode($commodityCode)
            ->setImportCommodityCode($importCommodityCode)
            ->setExportReasonType($exportReasonType)
            ->setItemNumber($itemNumber)
            ->setQuantity($quantity)
            ->setQuantityUnitOfMeasurement($quantityUnitOfMeasurement)
            ->setItemDescription($itemDescription)
            ->setUnitPrice($unitPrice)
            ->setNetWeight($netWeight)
            ->setGrossWeight($grossWeight)
            ->setManufacturingCountryCode($manufacturingCountryCode)
            ->setTaxesPaid($taxesPaid)
            ->setAdditionalInformation($additionalInformation)
            ->setLicenseNumber($licenseNumber)
            ->setItemReferences($itemReferences)
            ->setCustomsPaperworks($customsPaperworks);
    }
    /**
     * Get CommodityCode value
     * @return string|null
     */
    public function getCommodityCode()
    {
        return $this->CommodityCode;
    }
    /**
     * Set CommodityCode value
     * @param string $commodityCode
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setCommodityCode($commodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($commodityCode) && !is_string($commodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodityCode, true), gettype($commodityCode)), __LINE__);
        }
        $this->CommodityCode = $commodityCode;
        return $this;
    }
    /**
     * Get ImportCommodityCode value
     * @return string|null
     */
    public function getImportCommodityCode()
    {
        return $this->ImportCommodityCode;
    }
    /**
     * Set ImportCommodityCode value
     * @param string $importCommodityCode
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setImportCommodityCode($importCommodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($importCommodityCode) && !is_string($importCommodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importCommodityCode, true), gettype($importCommodityCode)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($importCommodityCode) && mb_strlen($importCommodityCode) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($importCommodityCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($importCommodityCode) && mb_strlen($importCommodityCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($importCommodityCode)), __LINE__);
        }
        $this->ImportCommodityCode = $importCommodityCode;
        return $this;
    }
    /**
     * Get ExportReasonType value
     * @return string|null
     */
    public function getExportReasonType()
    {
        return $this->ExportReasonType;
    }
    /**
     * Set ExportReasonType value
     * @param string $exportReasonType
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setExportReasonType($exportReasonType = null)
    {
        // validation for constraint: string
        if (!is_null($exportReasonType) && !is_string($exportReasonType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportReasonType, true), gettype($exportReasonType)), __LINE__);
        }
        $this->ExportReasonType = $exportReasonType;
        return $this;
    }
    /**
     * Get ItemNumber value
     * @return int|null
     */
    public function getItemNumber()
    {
        return $this->ItemNumber;
    }
    /**
     * Set ItemNumber value
     * @param int $itemNumber
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itemNumber) && !(is_int($itemNumber) || ctype_digit($itemNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemNumber, true), gettype($itemNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($itemNumber) && $itemNumber > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($itemNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($itemNumber) && $itemNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($itemNumber, true)), __LINE__);
        }
        $this->ItemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(1000000000)
        if (!is_null($quantity) && $quantity > 1000000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 1000000000', var_export($quantity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($quantity) && $quantity < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($quantity, true)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get QuantityUnitOfMeasurement value
     * @return string|null
     */
    public function getQuantityUnitOfMeasurement()
    {
        return $this->QuantityUnitOfMeasurement;
    }
    /**
     * Set QuantityUnitOfMeasurement value
     * @param string $quantityUnitOfMeasurement
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setQuantityUnitOfMeasurement($quantityUnitOfMeasurement = null)
    {
        // validation for constraint: string
        if (!is_null($quantityUnitOfMeasurement) && !is_string($quantityUnitOfMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantityUnitOfMeasurement, true), gettype($quantityUnitOfMeasurement)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($quantityUnitOfMeasurement) && mb_strlen($quantityUnitOfMeasurement) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($quantityUnitOfMeasurement)), __LINE__);
        }
        $this->QuantityUnitOfMeasurement = $quantityUnitOfMeasurement;
        return $this;
    }
    /**
     * Get ItemDescription value
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->ItemDescription;
    }
    /**
     * Set ItemDescription value
     * @param string $itemDescription
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        // validation for constraint: maxLength(512)
        if (!is_null($itemDescription) && mb_strlen($itemDescription) > 512) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 512', mb_strlen($itemDescription)), __LINE__);
        }
        $this->ItemDescription = $itemDescription;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get NetWeight value
     * @return float|null
     */
    public function getNetWeight()
    {
        return $this->NetWeight;
    }
    /**
     * Set NetWeight value
     * @param float $netWeight
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setNetWeight($netWeight = null)
    {
        // validation for constraint: float
        if (!is_null($netWeight) && !(is_float($netWeight) || is_numeric($netWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netWeight, true), gettype($netWeight)), __LINE__);
        }
        $this->NetWeight = $netWeight;
        return $this;
    }
    /**
     * Get GrossWeight value
     * @return float|null
     */
    public function getGrossWeight()
    {
        return $this->GrossWeight;
    }
    /**
     * Set GrossWeight value
     * @param float $grossWeight
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setGrossWeight($grossWeight = null)
    {
        // validation for constraint: float
        if (!is_null($grossWeight) && !(is_float($grossWeight) || is_numeric($grossWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossWeight, true), gettype($grossWeight)), __LINE__);
        }
        $this->GrossWeight = $grossWeight;
        return $this;
    }
    /**
     * Get ManufacturingCountryCode value
     * @return string|null
     */
    public function getManufacturingCountryCode()
    {
        return $this->ManufacturingCountryCode;
    }
    /**
     * Set ManufacturingCountryCode value
     * @param string $manufacturingCountryCode
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setManufacturingCountryCode($manufacturingCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturingCountryCode) && !is_string($manufacturingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturingCountryCode, true), gettype($manufacturingCountryCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($manufacturingCountryCode) && mb_strlen($manufacturingCountryCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($manufacturingCountryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($manufacturingCountryCode) && mb_strlen($manufacturingCountryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($manufacturingCountryCode)), __LINE__);
        }
        $this->ManufacturingCountryCode = $manufacturingCountryCode;
        return $this;
    }
    /**
     * Get TaxesPaid value
     * @return string|null
     */
    public function getTaxesPaid()
    {
        return $this->TaxesPaid;
    }
    /**
     * Set TaxesPaid value
     * @uses \App\Delivery\Dhl\EnumType\TaxesPaid::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\TaxesPaid::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxesPaid
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setTaxesPaid($taxesPaid = 'N')
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\TaxesPaid::valueIsValid($taxesPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\TaxesPaid', is_array($taxesPaid) ? implode(', ', $taxesPaid) : var_export($taxesPaid, true), implode(', ', \App\Delivery\Dhl\EnumType\TaxesPaid::getValidValues())), __LINE__);
        }
        $this->TaxesPaid = $taxesPaid;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \App\Delivery\Dhl\StructType\AdditionalInformation|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @param \App\Delivery\Dhl\StructType\AdditionalInformation $additionalInformation
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setAdditionalInformation(\App\Delivery\Dhl\StructType\AdditionalInformation $additionalInformation = null)
    {
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Get LicenseNumber value
     * @return string|null
     */
    public function getLicenseNumber()
    {
        return $this->LicenseNumber;
    }
    /**
     * Set LicenseNumber value
     * @param string $licenseNumber
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setLicenseNumber($licenseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($licenseNumber) && !is_string($licenseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseNumber, true), gettype($licenseNumber)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($licenseNumber) && mb_strlen($licenseNumber) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($licenseNumber)), __LINE__);
        }
        $this->LicenseNumber = $licenseNumber;
        return $this;
    }
    /**
     * Get ItemReferences value
     * @return \App\Delivery\Dhl\StructType\ItemReferences|null
     */
    public function getItemReferences()
    {
        return $this->ItemReferences;
    }
    /**
     * Set ItemReferences value
     * @param \App\Delivery\Dhl\StructType\ItemReferences $itemReferences
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setItemReferences(\App\Delivery\Dhl\StructType\ItemReferences $itemReferences = null)
    {
        $this->ItemReferences = $itemReferences;
        return $this;
    }
    /**
     * Get CustomsPaperworks value
     * @return \App\Delivery\Dhl\StructType\CustomsPaperworks|null
     */
    public function getCustomsPaperworks()
    {
        return $this->CustomsPaperworks;
    }
    /**
     * Set CustomsPaperworks value
     * @param \App\Delivery\Dhl\StructType\CustomsPaperworks $customsPaperworks
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setCustomsPaperworks(\App\Delivery\Dhl\StructType\CustomsPaperworks $customsPaperworks = null)
    {
        $this->CustomsPaperworks = $customsPaperworks;
        return $this;
    }
}
