<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_RequestedShipmentType StructType
 * @subpackage Structs
 */
class DocTypeRef_RequestedShipmentType extends AbstractStructBase
{
    /**
     * The ShipmentInfo
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public $ShipmentInfo;
    /**
     * The ShipTimestamp
     * Meta information extracted from the WSDL
     * - documentation: Identifies the date and time the package is tendered. Both the date and time portions of the string are expected to be used. The date should not be a past date or a date more than 10 days in the future. The time is the local time of
     * the shipment based on the shipper's time zone. The date component must be in the format: YYYY-MM-DD; the time component must be in the format: HH:MM:SS using a 24 hour clock. The date and time parts are separated by the letter T (e.g.
     * 2010-02-05T14:00:00 GMT+01:00).
     * - base: xsd:token
     * - maxLength: 29
     * - whiteSpace: collapse
     * @var string
     */
    public $ShipTimestamp;
    /**
     * The PickupLocationCloseTime
     * Meta information extracted from the WSDL
     * - documentation: Identifies the customer cut-off time for courier pick-up. Only the time portions is expected to be used. The time is the local time on the shipper's country where the package is available to be picked-up, and the component must be in
     * the format: HH:MM using a 24 hour clock (e.g. 14:00).
     * - base: xsd:token
     * - maxLength: 5
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PickupLocationCloseTime;
    /**
     * The SpecialPickupInstruction
     * Meta information extracted from the WSDL
     * - documentation: Details special pickup instructions you may wish to send to the DHL Courier .
     * - base: xsd:string
     * - maxLength: 75
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $SpecialPickupInstruction;
    /**
     * The PickupLocation
     * Meta information extracted from the WSDL
     * - documentation: Provides information on where the package should be picked up by DHL courier.
     * - base: xsd:string
     * - maxLength: 80
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PickupLocation;
    /**
     * The PaymentInfo
     * Meta information extracted from the WSDL
     * - documentation: Details the potential terms of trade for this specific shipment
     * @var string
     */
    public $PaymentInfo;
    /**
     * The InternationalDetail
     * Meta information extracted from the WSDL
     * - documentation: Conveys data elements for international shipping
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_InternationDetailType
     */
    public $InternationalDetail;
    /**
     * The OnDemandDeliveryOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_OnDemandDeliveryOptions
     */
    public $OnDemandDeliveryOptions;
    /**
     * The OnDemandDeliveryURLRequest
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $OnDemandDeliveryURLRequest;
    /**
     * The Ship
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_ShipType
     */
    public $Ship;
    /**
     * The Packages
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_PackagesType
     */
    public $Packages;
    /**
     * The DangerousGoods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_DangerousGoods
     */
    public $DangerousGoods;
    /**
     * The GetRateEstimates
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $GetRateEstimates;
    /**
     * The ShipmentNotifications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentNotifications
     */
    public $ShipmentNotifications;
    /**
     * Constructor method for docTypeRef_RequestedShipmentType
     * @uses DocTypeRef_RequestedShipmentType::setShipmentInfo()
     * @uses DocTypeRef_RequestedShipmentType::setShipTimestamp()
     * @uses DocTypeRef_RequestedShipmentType::setPickupLocationCloseTime()
     * @uses DocTypeRef_RequestedShipmentType::setSpecialPickupInstruction()
     * @uses DocTypeRef_RequestedShipmentType::setPickupLocation()
     * @uses DocTypeRef_RequestedShipmentType::setPaymentInfo()
     * @uses DocTypeRef_RequestedShipmentType::setInternationalDetail()
     * @uses DocTypeRef_RequestedShipmentType::setOnDemandDeliveryOptions()
     * @uses DocTypeRef_RequestedShipmentType::setOnDemandDeliveryURLRequest()
     * @uses DocTypeRef_RequestedShipmentType::setShip()
     * @uses DocTypeRef_RequestedShipmentType::setPackages()
     * @uses DocTypeRef_RequestedShipmentType::setDangerousGoods()
     * @uses DocTypeRef_RequestedShipmentType::setGetRateEstimates()
     * @uses DocTypeRef_RequestedShipmentType::setShipmentNotifications()
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType $shipmentInfo
     * @param string $shipTimestamp
     * @param string $pickupLocationCloseTime
     * @param string $specialPickupInstruction
     * @param string $pickupLocation
     * @param string $paymentInfo
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_InternationDetailType $internationalDetail
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_OnDemandDeliveryOptions $onDemandDeliveryOptions
     * @param string $onDemandDeliveryURLRequest
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_ShipType $ship
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_PackagesType $packages
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_DangerousGoods $dangerousGoods
     * @param string $getRateEstimates
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentNotifications $shipmentNotifications
     */
    public function __construct(\App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType $shipmentInfo = null, $shipTimestamp = null, $pickupLocationCloseTime = null, $specialPickupInstruction = null, $pickupLocation = null, $paymentInfo = null, \App\Delivery\Dhl\StructType\DocTypeRef_InternationDetailType $internationalDetail = null, \App\Delivery\Dhl\StructType\DocTypeRef_OnDemandDeliveryOptions $onDemandDeliveryOptions = null, $onDemandDeliveryURLRequest = 'N', \App\Delivery\Dhl\StructType\DocTypeRef_ShipType $ship = null, \App\Delivery\Dhl\StructType\DocTypeRef_PackagesType $packages = null, \App\Delivery\Dhl\StructType\DocTypeRef_DangerousGoods $dangerousGoods = null, $getRateEstimates = 'N', \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentNotifications $shipmentNotifications = null)
    {
        $this
            ->setShipmentInfo($shipmentInfo)
            ->setShipTimestamp($shipTimestamp)
            ->setPickupLocationCloseTime($pickupLocationCloseTime)
            ->setSpecialPickupInstruction($specialPickupInstruction)
            ->setPickupLocation($pickupLocation)
            ->setPaymentInfo($paymentInfo)
            ->setInternationalDetail($internationalDetail)
            ->setOnDemandDeliveryOptions($onDemandDeliveryOptions)
            ->setOnDemandDeliveryURLRequest($onDemandDeliveryURLRequest)
            ->setShip($ship)
            ->setPackages($packages)
            ->setDangerousGoods($dangerousGoods)
            ->setGetRateEstimates($getRateEstimates)
            ->setShipmentNotifications($shipmentNotifications);
    }
    /**
     * Get ShipmentInfo value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType|null
     */
    public function getShipmentInfo()
    {
        return $this->ShipmentInfo;
    }
    /**
     * Set ShipmentInfo value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType $shipmentInfo
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setShipmentInfo(\App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType $shipmentInfo = null)
    {
        $this->ShipmentInfo = $shipmentInfo;
        return $this;
    }
    /**
     * Get ShipTimestamp value
     * @return string|null
     */
    public function getShipTimestamp()
    {
        return $this->ShipTimestamp;
    }
    /**
     * Set ShipTimestamp value
     * @param string $shipTimestamp
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setShipTimestamp($shipTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($shipTimestamp) && !is_string($shipTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipTimestamp, true), gettype($shipTimestamp)), __LINE__);
        }
        // validation for constraint: maxLength(29)
        if (!is_null($shipTimestamp) && mb_strlen($shipTimestamp) > 29) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 29', mb_strlen($shipTimestamp)), __LINE__);
        }
        $this->ShipTimestamp = $shipTimestamp;
        return $this;
    }
    /**
     * Get PickupLocationCloseTime value
     * @return string|null
     */
    public function getPickupLocationCloseTime()
    {
        return $this->PickupLocationCloseTime;
    }
    /**
     * Set PickupLocationCloseTime value
     * @param string $pickupLocationCloseTime
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setPickupLocationCloseTime($pickupLocationCloseTime = null)
    {
        // validation for constraint: string
        if (!is_null($pickupLocationCloseTime) && !is_string($pickupLocationCloseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupLocationCloseTime, true), gettype($pickupLocationCloseTime)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($pickupLocationCloseTime) && mb_strlen($pickupLocationCloseTime) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($pickupLocationCloseTime)), __LINE__);
        }
        $this->PickupLocationCloseTime = $pickupLocationCloseTime;
        return $this;
    }
    /**
     * Get SpecialPickupInstruction value
     * @return string|null
     */
    public function getSpecialPickupInstruction()
    {
        return $this->SpecialPickupInstruction;
    }
    /**
     * Set SpecialPickupInstruction value
     * @param string $specialPickupInstruction
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setSpecialPickupInstruction($specialPickupInstruction = null)
    {
        // validation for constraint: string
        if (!is_null($specialPickupInstruction) && !is_string($specialPickupInstruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialPickupInstruction, true), gettype($specialPickupInstruction)), __LINE__);
        }
        // validation for constraint: maxLength(75)
        if (!is_null($specialPickupInstruction) && mb_strlen($specialPickupInstruction) > 75) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 75', mb_strlen($specialPickupInstruction)), __LINE__);
        }
        $this->SpecialPickupInstruction = $specialPickupInstruction;
        return $this;
    }
    /**
     * Get PickupLocation value
     * @return string|null
     */
    public function getPickupLocation()
    {
        return $this->PickupLocation;
    }
    /**
     * Set PickupLocation value
     * @param string $pickupLocation
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setPickupLocation($pickupLocation = null)
    {
        // validation for constraint: string
        if (!is_null($pickupLocation) && !is_string($pickupLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupLocation, true), gettype($pickupLocation)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($pickupLocation) && mb_strlen($pickupLocation) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($pickupLocation)), __LINE__);
        }
        $this->PickupLocation = $pickupLocation;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return string|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @uses \App\Delivery\Dhl\EnumType\PaymentInfo::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\PaymentInfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentInfo
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setPaymentInfo($paymentInfo = null)
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\PaymentInfo::valueIsValid($paymentInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\PaymentInfo', is_array($paymentInfo) ? implode(', ', $paymentInfo) : var_export($paymentInfo, true), implode(', ', \App\Delivery\Dhl\EnumType\PaymentInfo::getValidValues())), __LINE__);
        }
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get InternationalDetail value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_InternationDetailType|null
     */
    public function getInternationalDetail()
    {
        return $this->InternationalDetail;
    }
    /**
     * Set InternationalDetail value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_InternationDetailType $internationalDetail
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setInternationalDetail(\App\Delivery\Dhl\StructType\DocTypeRef_InternationDetailType $internationalDetail = null)
    {
        $this->InternationalDetail = $internationalDetail;
        return $this;
    }
    /**
     * Get OnDemandDeliveryOptions value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_OnDemandDeliveryOptions|null
     */
    public function getOnDemandDeliveryOptions()
    {
        return $this->OnDemandDeliveryOptions;
    }
    /**
     * Set OnDemandDeliveryOptions value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_OnDemandDeliveryOptions $onDemandDeliveryOptions
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setOnDemandDeliveryOptions(\App\Delivery\Dhl\StructType\DocTypeRef_OnDemandDeliveryOptions $onDemandDeliveryOptions = null)
    {
        $this->OnDemandDeliveryOptions = $onDemandDeliveryOptions;
        return $this;
    }
    /**
     * Get OnDemandDeliveryURLRequest value
     * @return string|null
     */
    public function getOnDemandDeliveryURLRequest()
    {
        return $this->OnDemandDeliveryURLRequest;
    }
    /**
     * Set OnDemandDeliveryURLRequest value
     * @uses \App\Delivery\Dhl\EnumType\OnDemandDeliveryURLRequest::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\OnDemandDeliveryURLRequest::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $onDemandDeliveryURLRequest
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setOnDemandDeliveryURLRequest($onDemandDeliveryURLRequest = 'N')
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\OnDemandDeliveryURLRequest::valueIsValid($onDemandDeliveryURLRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\OnDemandDeliveryURLRequest', is_array($onDemandDeliveryURLRequest) ? implode(', ', $onDemandDeliveryURLRequest) : var_export($onDemandDeliveryURLRequest, true), implode(', ', \App\Delivery\Dhl\EnumType\OnDemandDeliveryURLRequest::getValidValues())), __LINE__);
        }
        $this->OnDemandDeliveryURLRequest = $onDemandDeliveryURLRequest;
        return $this;
    }
    /**
     * Get Ship value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipType|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_ShipType $ship
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setShip(\App\Delivery\Dhl\StructType\DocTypeRef_ShipType $ship = null)
    {
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Get Packages value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_PackagesType|null
     */
    public function getPackages()
    {
        return $this->Packages;
    }
    /**
     * Set Packages value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_PackagesType $packages
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setPackages(\App\Delivery\Dhl\StructType\DocTypeRef_PackagesType $packages = null)
    {
        $this->Packages = $packages;
        return $this;
    }
    /**
     * Get DangerousGoods value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DangerousGoods|null
     */
    public function getDangerousGoods()
    {
        return $this->DangerousGoods;
    }
    /**
     * Set DangerousGoods value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_DangerousGoods $dangerousGoods
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setDangerousGoods(\App\Delivery\Dhl\StructType\DocTypeRef_DangerousGoods $dangerousGoods = null)
    {
        $this->DangerousGoods = $dangerousGoods;
        return $this;
    }
    /**
     * Get GetRateEstimates value
     * @return string|null
     */
    public function getGetRateEstimates()
    {
        return $this->GetRateEstimates;
    }
    /**
     * Set GetRateEstimates value
     * @uses \App\Delivery\Dhl\EnumType\GetRateEstimates::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\GetRateEstimates::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $getRateEstimates
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setGetRateEstimates($getRateEstimates = 'N')
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\GetRateEstimates::valueIsValid($getRateEstimates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\GetRateEstimates', is_array($getRateEstimates) ? implode(', ', $getRateEstimates) : var_export($getRateEstimates, true), implode(', ', \App\Delivery\Dhl\EnumType\GetRateEstimates::getValidValues())), __LINE__);
        }
        $this->GetRateEstimates = $getRateEstimates;
        return $this;
    }
    /**
     * Get ShipmentNotifications value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentNotifications|null
     */
    public function getShipmentNotifications()
    {
        return $this->ShipmentNotifications;
    }
    /**
     * Set ShipmentNotifications value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentNotifications $shipmentNotifications
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public function setShipmentNotifications(\App\Delivery\Dhl\StructType\DocTypeRef_ShipmentNotifications $shipmentNotifications = null)
    {
        $this->ShipmentNotifications = $shipmentNotifications;
        return $this;
    }
}
