<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service2 StructType
 * @subpackage Structs
 */
class Service2 extends AbstractStructBase
{
    /**
     * The ServiceType
     * Meta information extracted from the WSDL
     * - documentation: Enter II if you wish to get a quote for Insurance with your prospect shipment. If not needed then leave the SpecialServices section out
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $ServiceType;
    /**
     * The LocalServiceType
     * Meta information extracted from the WSDL
     * - documentation: The DHL local or country specific Product Code used to ship the items
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $LocalServiceType;
    /**
     * The ServiceValue
     * Meta information extracted from the WSDL
     * - documentation: Monetary value of service (e.g. Insured Value) – this is needed if you wish to get a quote on Insurance with your prospect shipment
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $ServiceValue;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Currency code – this is needed if you wish to get a quote on Insurance with your prospect shipment
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $CurrencyCode;
    /**
     * The PaymentCode
     * Meta information extracted from the WSDL
     * - documentation: For future use
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PaymentCode;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - documentation: For future use
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - documentation: For future use
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The TextInstruction
     * Meta information extracted from the WSDL
     * - documentation: For future use
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $TextInstruction;
    /**
     * Constructor method for Service2
     * @uses Service2::setServiceType()
     * @uses Service2::setLocalServiceType()
     * @uses Service2::setServiceValue()
     * @uses Service2::setCurrencyCode()
     * @uses Service2::setPaymentCode()
     * @uses Service2::setStartDate()
     * @uses Service2::setEndDate()
     * @uses Service2::setTextInstruction()
     * @param string $serviceType
     * @param string $localServiceType
     * @param float $serviceValue
     * @param string $currencyCode
     * @param string $paymentCode
     * @param string $startDate
     * @param string $endDate
     * @param string $textInstruction
     */
    public function __construct($serviceType = null, $localServiceType = null, $serviceValue = null, $currencyCode = null, $paymentCode = null, $startDate = null, $endDate = null, $textInstruction = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setLocalServiceType($localServiceType)
            ->setServiceValue($serviceValue)
            ->setCurrencyCode($currencyCode)
            ->setPaymentCode($paymentCode)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setTextInstruction($textInstruction);
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param string $serviceType
     * @return \App\Delivery\Dhl\StructType\Service2
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceType, true), gettype($serviceType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($serviceType) && mb_strlen($serviceType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($serviceType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($serviceType) && mb_strlen($serviceType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($serviceType)), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get LocalServiceType value
     * @return string|null
     */
    public function getLocalServiceType()
    {
        return $this->LocalServiceType;
    }
    /**
     * Set LocalServiceType value
     * @param string $localServiceType
     * @return \App\Delivery\Dhl\StructType\Service2
     */
    public function setLocalServiceType($localServiceType = null)
    {
        // validation for constraint: string
        if (!is_null($localServiceType) && !is_string($localServiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localServiceType, true), gettype($localServiceType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($localServiceType) && mb_strlen($localServiceType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($localServiceType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($localServiceType) && mb_strlen($localServiceType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($localServiceType)), __LINE__);
        }
        $this->LocalServiceType = $localServiceType;
        return $this;
    }
    /**
     * Get ServiceValue value
     * @return float|null
     */
    public function getServiceValue()
    {
        return $this->ServiceValue;
    }
    /**
     * Set ServiceValue value
     * @param float $serviceValue
     * @return \App\Delivery\Dhl\StructType\Service2
     */
    public function setServiceValue($serviceValue = null)
    {
        // validation for constraint: float
        if (!is_null($serviceValue) && !(is_float($serviceValue) || is_numeric($serviceValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($serviceValue, true), gettype($serviceValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($serviceValue) && mb_strlen(mb_substr($serviceValue, false !== mb_strpos($serviceValue, '.') ? mb_strpos($serviceValue, '.') + 1 : mb_strlen($serviceValue))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($serviceValue, true), mb_strlen(mb_substr($serviceValue, mb_strpos($serviceValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($serviceValue) && mb_strlen(preg_replace('/(\D)/', '', $serviceValue)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($serviceValue, true), mb_strlen(preg_replace('/(\D)/', '', $serviceValue))), __LINE__);
        }
        $this->ServiceValue = $serviceValue;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \App\Delivery\Dhl\StructType\Service2
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($currencyCode) && mb_strlen($currencyCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($currencyCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($currencyCode) && mb_strlen($currencyCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get PaymentCode value
     * @return string|null
     */
    public function getPaymentCode()
    {
        return $this->PaymentCode;
    }
    /**
     * Set PaymentCode value
     * @param string $paymentCode
     * @return \App\Delivery\Dhl\StructType\Service2
     */
    public function setPaymentCode($paymentCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCode) && !is_string($paymentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCode, true), gettype($paymentCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($paymentCode) && mb_strlen($paymentCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($paymentCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($paymentCode) && mb_strlen($paymentCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($paymentCode)), __LINE__);
        }
        $this->PaymentCode = $paymentCode;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \App\Delivery\Dhl\StructType\Service2
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \App\Delivery\Dhl\StructType\Service2
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get TextInstruction value
     * @return string|null
     */
    public function getTextInstruction()
    {
        return $this->TextInstruction;
    }
    /**
     * Set TextInstruction value
     * @param string $textInstruction
     * @return \App\Delivery\Dhl\StructType\Service2
     */
    public function setTextInstruction($textInstruction = null)
    {
        // validation for constraint: string
        if (!is_null($textInstruction) && !is_string($textInstruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textInstruction, true), gettype($textInstruction)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($textInstruction) && mb_strlen($textInstruction) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($textInstruction)), __LINE__);
        }
        $this->TextInstruction = $textInstruction;
        return $this;
    }
}
