<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_RequestedPackagesType StructType
 * @subpackage Structs
 */
class DocTypeRef_RequestedPackagesType extends AbstractStructBase
{
    /**
     * The number
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $number;
    /**
     * The InsuredValue
     * Meta information extracted from the WSDL
     * - documentation: Insurance values of the package
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - minOccurs: 0
     * - totalDigits: 15
     * - whiteSpace: collapse
     * @var float
     */
    public $InsuredValue;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - documentation: The weight of the package.
     * - base: xsd:decimal
     * - whiteSpace: collapse
     * @var float
     */
    public $Weight;
    /**
     * The PieceIdentificationNumber
     * Meta information extracted from the WSDL
     * - documentation: You can request your own Piece ID range from your DHL Express IT consultant and store these locally in your integration however this is not needed as if you leave this tag then DHL will automatically assign the piece ID centrally
     * - base: xsd:token
     * - maxLength: 35
     * - minLength: 0
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PieceIdentificationNumber;
    /**
     * The UseOwnPieceIdentificationNumber
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $UseOwnPieceIdentificationNumber;
    /**
     * The PackageContentDescription
     * Meta information extracted from the WSDL
     * - documentation: This optional field allows you to provide the content description on a piece level instead of Shipment level
     * - base: xsd:string
     * - maxLength: 70
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PackageContentDescription;
    /**
     * The Dimensions
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType
     */
    public $Dimensions;
    /**
     * The CustomerReferences
     * Meta information extracted from the WSDL
     * - documentation: Customer Reference for the piece
     * - base: xsd:token
     * - maxLength: 50
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $CustomerReferences;
    /**
     * The ParentPieceIdentificationNumber
     * Meta information extracted from the WSDL
     * - documentation: Parent (Mother) Piece ID number. This field will be used to indicate the Mother Shipment's Piece ID for linkage purposes.
     * - base: xsd:token
     * - maxLength: 35
     * - minLength: 0
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ParentPieceIdentificationNumber;
    /**
     * The CustomerReferenceType
     * Meta information extracted from the WSDL
     * - documentation: Shipment reference type
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $CustomerReferenceType;
    /**
     * The PackageTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Global Package Type codes 3BX Box 3 2BC Box 2 (Cube) 2BP Box 2 (Flat) CE1 Card Envelope 7BX Box 7 6BX Box 6 4BX Box 4 2BX Box 2 (Tablet) 1CE Card Envelope WB1 1 Wine Box WB3 3 Wine Box XPD Express Envelope 8BX Box 8 (Jumbo Large) 5BX
     * Box 5 (Jumbo Small) WB6 6 Wine Box TBL Tube Large TBS Tube Small WB2 2 Wine Box
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PackageTypeCode;
    /**
     * The BespokeLabelData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\BespokeLabelData
     */
    public $BespokeLabelData;
    /**
     * The PackageReferences
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\PackageReferences
     */
    public $PackageReferences;
    /**
     * Constructor method for docTypeRef_RequestedPackagesType
     * @uses DocTypeRef_RequestedPackagesType::setNumber()
     * @uses DocTypeRef_RequestedPackagesType::setInsuredValue()
     * @uses DocTypeRef_RequestedPackagesType::setWeight()
     * @uses DocTypeRef_RequestedPackagesType::setPieceIdentificationNumber()
     * @uses DocTypeRef_RequestedPackagesType::setUseOwnPieceIdentificationNumber()
     * @uses DocTypeRef_RequestedPackagesType::setPackageContentDescription()
     * @uses DocTypeRef_RequestedPackagesType::setDimensions()
     * @uses DocTypeRef_RequestedPackagesType::setCustomerReferences()
     * @uses DocTypeRef_RequestedPackagesType::setParentPieceIdentificationNumber()
     * @uses DocTypeRef_RequestedPackagesType::setCustomerReferenceType()
     * @uses DocTypeRef_RequestedPackagesType::setPackageTypeCode()
     * @uses DocTypeRef_RequestedPackagesType::setBespokeLabelData()
     * @uses DocTypeRef_RequestedPackagesType::setPackageReferences()
     * @param int $number
     * @param float $insuredValue
     * @param float $weight
     * @param string $pieceIdentificationNumber
     * @param string $useOwnPieceIdentificationNumber
     * @param string $packageContentDescription
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType $dimensions
     * @param string $customerReferences
     * @param string $parentPieceIdentificationNumber
     * @param string $customerReferenceType
     * @param string $packageTypeCode
     * @param \App\Delivery\Dhl\StructType\BespokeLabelData $bespokeLabelData
     * @param \App\Delivery\Dhl\StructType\PackageReferences $packageReferences
     */
    public function __construct($number = null, $insuredValue = null, $weight = null, $pieceIdentificationNumber = null, $useOwnPieceIdentificationNumber = 'N', $packageContentDescription = null, \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType $dimensions = null, $customerReferences = null, $parentPieceIdentificationNumber = null, $customerReferenceType = null, $packageTypeCode = null, \App\Delivery\Dhl\StructType\BespokeLabelData $bespokeLabelData = null, \App\Delivery\Dhl\StructType\PackageReferences $packageReferences = null)
    {
        $this
            ->setNumber($number)
            ->setInsuredValue($insuredValue)
            ->setWeight($weight)
            ->setPieceIdentificationNumber($pieceIdentificationNumber)
            ->setUseOwnPieceIdentificationNumber($useOwnPieceIdentificationNumber)
            ->setPackageContentDescription($packageContentDescription)
            ->setDimensions($dimensions)
            ->setCustomerReferences($customerReferences)
            ->setParentPieceIdentificationNumber($parentPieceIdentificationNumber)
            ->setCustomerReferenceType($customerReferenceType)
            ->setPackageTypeCode($packageTypeCode)
            ->setBespokeLabelData($bespokeLabelData)
            ->setPackageReferences($packageReferences);
    }
    /**
     * Get number value
     * @return int
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($number) && $number > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($number) && $number < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($number, true)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get InsuredValue value
     * @return float|null
     */
    public function getInsuredValue()
    {
        return $this->InsuredValue;
    }
    /**
     * Set InsuredValue value
     * @param float $insuredValue
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setInsuredValue($insuredValue = null)
    {
        // validation for constraint: float
        if (!is_null($insuredValue) && !(is_float($insuredValue) || is_numeric($insuredValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuredValue, true), gettype($insuredValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($insuredValue) && mb_strlen(mb_substr($insuredValue, false !== mb_strpos($insuredValue, '.') ? mb_strpos($insuredValue, '.') + 1 : mb_strlen($insuredValue))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($insuredValue, true), mb_strlen(mb_substr($insuredValue, mb_strpos($insuredValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($insuredValue) && mb_strlen(preg_replace('/(\D)/', '', $insuredValue)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($insuredValue, true), mb_strlen(preg_replace('/(\D)/', '', $insuredValue))), __LINE__);
        }
        $this->InsuredValue = $insuredValue;
        return $this;
    }
    /**
     * Get Weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get PieceIdentificationNumber value
     * @return string|null
     */
    public function getPieceIdentificationNumber()
    {
        return $this->PieceIdentificationNumber;
    }
    /**
     * Set PieceIdentificationNumber value
     * @param string $pieceIdentificationNumber
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setPieceIdentificationNumber($pieceIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pieceIdentificationNumber) && !is_string($pieceIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pieceIdentificationNumber, true), gettype($pieceIdentificationNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($pieceIdentificationNumber) && mb_strlen($pieceIdentificationNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($pieceIdentificationNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($pieceIdentificationNumber) && mb_strlen($pieceIdentificationNumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($pieceIdentificationNumber)), __LINE__);
        }
        $this->PieceIdentificationNumber = $pieceIdentificationNumber;
        return $this;
    }
    /**
     * Get UseOwnPieceIdentificationNumber value
     * @return string|null
     */
    public function getUseOwnPieceIdentificationNumber()
    {
        return $this->UseOwnPieceIdentificationNumber;
    }
    /**
     * Set UseOwnPieceIdentificationNumber value
     * @uses \App\Delivery\Dhl\EnumType\UseOwnPieceIdentificationNumber::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\UseOwnPieceIdentificationNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useOwnPieceIdentificationNumber
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setUseOwnPieceIdentificationNumber($useOwnPieceIdentificationNumber = 'N')
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\UseOwnPieceIdentificationNumber::valueIsValid($useOwnPieceIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\UseOwnPieceIdentificationNumber', is_array($useOwnPieceIdentificationNumber) ? implode(', ', $useOwnPieceIdentificationNumber) : var_export($useOwnPieceIdentificationNumber, true), implode(', ', \App\Delivery\Dhl\EnumType\UseOwnPieceIdentificationNumber::getValidValues())), __LINE__);
        }
        $this->UseOwnPieceIdentificationNumber = $useOwnPieceIdentificationNumber;
        return $this;
    }
    /**
     * Get PackageContentDescription value
     * @return string|null
     */
    public function getPackageContentDescription()
    {
        return $this->PackageContentDescription;
    }
    /**
     * Set PackageContentDescription value
     * @param string $packageContentDescription
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setPackageContentDescription($packageContentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($packageContentDescription) && !is_string($packageContentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageContentDescription, true), gettype($packageContentDescription)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($packageContentDescription) && mb_strlen($packageContentDescription) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($packageContentDescription)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($packageContentDescription) && mb_strlen($packageContentDescription) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($packageContentDescription)), __LINE__);
        }
        $this->PackageContentDescription = $packageContentDescription;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType $dimensions
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setDimensions(\App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get CustomerReferences value
     * @return string|null
     */
    public function getCustomerReferences()
    {
        return $this->CustomerReferences;
    }
    /**
     * Set CustomerReferences value
     * @param string $customerReferences
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setCustomerReferences($customerReferences = null)
    {
        // validation for constraint: string
        if (!is_null($customerReferences) && !is_string($customerReferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReferences, true), gettype($customerReferences)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($customerReferences) && mb_strlen($customerReferences) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($customerReferences)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerReferences) && mb_strlen($customerReferences) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerReferences)), __LINE__);
        }
        $this->CustomerReferences = $customerReferences;
        return $this;
    }
    /**
     * Get ParentPieceIdentificationNumber value
     * @return string|null
     */
    public function getParentPieceIdentificationNumber()
    {
        return $this->ParentPieceIdentificationNumber;
    }
    /**
     * Set ParentPieceIdentificationNumber value
     * @param string $parentPieceIdentificationNumber
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setParentPieceIdentificationNumber($parentPieceIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parentPieceIdentificationNumber) && !is_string($parentPieceIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentPieceIdentificationNumber, true), gettype($parentPieceIdentificationNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($parentPieceIdentificationNumber) && mb_strlen($parentPieceIdentificationNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($parentPieceIdentificationNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($parentPieceIdentificationNumber) && mb_strlen($parentPieceIdentificationNumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($parentPieceIdentificationNumber)), __LINE__);
        }
        $this->ParentPieceIdentificationNumber = $parentPieceIdentificationNumber;
        return $this;
    }
    /**
     * Get CustomerReferenceType value
     * @return string|null
     */
    public function getCustomerReferenceType()
    {
        return $this->CustomerReferenceType;
    }
    /**
     * Set CustomerReferenceType value
     * @param string $customerReferenceType
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setCustomerReferenceType($customerReferenceType = null)
    {
        // validation for constraint: string
        if (!is_null($customerReferenceType) && !is_string($customerReferenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReferenceType, true), gettype($customerReferenceType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($customerReferenceType) && mb_strlen($customerReferenceType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($customerReferenceType)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($customerReferenceType) && mb_strlen($customerReferenceType) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($customerReferenceType)), __LINE__);
        }
        $this->CustomerReferenceType = $customerReferenceType;
        return $this;
    }
    /**
     * Get PackageTypeCode value
     * @return string|null
     */
    public function getPackageTypeCode()
    {
        return $this->PackageTypeCode;
    }
    /**
     * Set PackageTypeCode value
     * @param string $packageTypeCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setPackageTypeCode($packageTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($packageTypeCode) && !is_string($packageTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageTypeCode, true), gettype($packageTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($packageTypeCode) && mb_strlen($packageTypeCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($packageTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($packageTypeCode) && mb_strlen($packageTypeCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($packageTypeCode)), __LINE__);
        }
        $this->PackageTypeCode = $packageTypeCode;
        return $this;
    }
    /**
     * Get BespokeLabelData value
     * @return \App\Delivery\Dhl\StructType\BespokeLabelData|null
     */
    public function getBespokeLabelData()
    {
        return $this->BespokeLabelData;
    }
    /**
     * Set BespokeLabelData value
     * @param \App\Delivery\Dhl\StructType\BespokeLabelData $bespokeLabelData
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setBespokeLabelData(\App\Delivery\Dhl\StructType\BespokeLabelData $bespokeLabelData = null)
    {
        $this->BespokeLabelData = $bespokeLabelData;
        return $this;
    }
    /**
     * Get PackageReferences value
     * @return \App\Delivery\Dhl\StructType\PackageReferences|null
     */
    public function getPackageReferences()
    {
        return $this->PackageReferences;
    }
    /**
     * Set PackageReferences value
     * @param \App\Delivery\Dhl\StructType\PackageReferences $packageReferences
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setPackageReferences(\App\Delivery\Dhl\StructType\PackageReferences $packageReferences = null)
    {
        $this->PackageReferences = $packageReferences;
        return $this;
    }
}
