<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ContactType StructType
 * @subpackage Structs
 */
class DocTypeRef_ContactType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - documentation: A contact name of a person
     * - base: xsd:token
     * - maxLength: 45
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $PersonName;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: The company name the person is working in | The company name
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $CompanyName;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - documentation: The contact person phone number
     * - base: xsd:token
     * - maxLength: 25
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $PhoneNumber;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - documentation: The email address of the contact person
     * - base: xsd:token
     * - maxLength: 50
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $EmailAddress;
    /**
     * The MobilePhoneNumber
     * Meta information extracted from the WSDL
     * - documentation: The mobile phone number of the contact person
     * - base: xsd:token
     * - maxLength: 25
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $MobilePhoneNumber;
    /**
     * Constructor method for docTypeRef_ContactType
     * @uses DocTypeRef_ContactType::setPersonName()
     * @uses DocTypeRef_ContactType::setCompanyName()
     * @uses DocTypeRef_ContactType::setPhoneNumber()
     * @uses DocTypeRef_ContactType::setEmailAddress()
     * @uses DocTypeRef_ContactType::setMobilePhoneNumber()
     * @param string $personName
     * @param string $companyName
     * @param string $phoneNumber
     * @param string $emailAddress
     * @param string $mobilePhoneNumber
     */
    public function __construct($personName = null, $companyName = null, $phoneNumber = null, $emailAddress = null, $mobilePhoneNumber = null)
    {
        $this
            ->setPersonName($personName)
            ->setCompanyName($companyName)
            ->setPhoneNumber($phoneNumber)
            ->setEmailAddress($emailAddress)
            ->setMobilePhoneNumber($mobilePhoneNumber);
    }
    /**
     * Get PersonName value
     * @return string|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param string $personName
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ContactType
     */
    public function setPersonName($personName = null)
    {
        // validation for constraint: string
        if (!is_null($personName) && !is_string($personName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personName, true), gettype($personName)), __LINE__);
        }
        // validation for constraint: maxLength(45)
        if (!is_null($personName) && mb_strlen($personName) > 45) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 45', mb_strlen($personName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($personName) && mb_strlen($personName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($personName)), __LINE__);
        }
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ContactType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($companyName) && mb_strlen($companyName) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($companyName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($companyName) && mb_strlen($companyName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ContactType
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($phoneNumber) && mb_strlen($phoneNumber) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($phoneNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($phoneNumber) && mb_strlen($phoneNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ContactType
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($emailAddress) && mb_strlen($emailAddress) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($emailAddress)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($emailAddress) && mb_strlen($emailAddress) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get MobilePhoneNumber value
     * @return string|null
     */
    public function getMobilePhoneNumber()
    {
        return $this->MobilePhoneNumber;
    }
    /**
     * Set MobilePhoneNumber value
     * @param string $mobilePhoneNumber
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ContactType
     */
    public function setMobilePhoneNumber($mobilePhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhoneNumber) && !is_string($mobilePhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhoneNumber, true), gettype($mobilePhoneNumber)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($mobilePhoneNumber) && mb_strlen($mobilePhoneNumber) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($mobilePhoneNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($mobilePhoneNumber) && mb_strlen($mobilePhoneNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($mobilePhoneNumber)), __LINE__);
        }
        $this->MobilePhoneNumber = $mobilePhoneNumber;
        return $this;
    }
}
