<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notification StructType
 * @subpackage Structs
 */
class Notification extends AbstractStructBase
{
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - documentation: Short description of the error / status
     * - base: xsd:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The DetailedMessage
     * Meta information extracted from the WSDL
     * - documentation: Detailed description of the error / status
     * - base: xsd:string
     * - maxLength: 1024
     * - minOccurs: 0
     * @var string
     */
    public $DetailedMessage;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * Constructor method for Notification
     * @uses Notification::setMessage()
     * @uses Notification::setDetailedMessage()
     * @uses Notification::setCode()
     * @param string $message
     * @param string $detailedMessage
     * @param string $code
     */
    public function __construct($message = null, $detailedMessage = null, $code = null)
    {
        $this
            ->setMessage($message)
            ->setDetailedMessage($detailedMessage)
            ->setCode($code);
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \App\Delivery\Dhl\StructType\Notification
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($message) && mb_strlen($message) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get DetailedMessage value
     * @return string|null
     */
    public function getDetailedMessage()
    {
        return $this->DetailedMessage;
    }
    /**
     * Set DetailedMessage value
     * @param string $detailedMessage
     * @return \App\Delivery\Dhl\StructType\Notification
     */
    public function setDetailedMessage($detailedMessage = null)
    {
        // validation for constraint: string
        if (!is_null($detailedMessage) && !is_string($detailedMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailedMessage, true), gettype($detailedMessage)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($detailedMessage) && mb_strlen($detailedMessage) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($detailedMessage)), __LINE__);
        }
        $this->DetailedMessage = $detailedMessage;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \App\Delivery\Dhl\StructType\Notification
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
