<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_WeightType StructType
 * @subpackage Structs
 */
class DocTypeRef_WeightType extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: Sum of the weight of the individual pieces/packages the rating request is for. Minimum allowed weight is 0.1kg – please see your DHL Account rate card for more information on minimum and maximum weights per piece.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - totalDigits: 12
     * @var float
     */
    public $Value;
    /**
     * Constructor method for docTypeRef_WeightType
     * @uses DocTypeRef_WeightType::setValue()
     * @param float $value
     */
    public function __construct($value = null)
    {
        $this
            ->setValue($value);
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_WeightType
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($value) && mb_strlen(mb_substr($value, false !== mb_strpos($value, '.') ? mb_strpos($value, '.') + 1 : mb_strlen($value))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($value, true), mb_strlen(mb_substr($value, mb_strpos($value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($value) && mb_strlen(preg_replace('/(\D)/', '', $value)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($value, true), mb_strlen(preg_replace('/(\D)/', '', $value))), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
