<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ChargeType StructType
 * @subpackage Structs
 */
class DocTypeRef_ChargeType extends AbstractStructBase
{
    /**
     * The ChargeCode
     * Meta information extracted from the WSDL
     * - documentation: Global Product Code or Optional Special Services | Special service or extra charge code – this is the code you would have to use in the ShipmentRequest message if you wish to add an optional Service such as Insurance
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCode;
    /**
     * The LocalChargeCode
     * Meta information extracted from the WSDL
     * - documentation: Local service code
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $LocalChargeCode;
    /**
     * The ChargeType
     * Meta information extracted from the WSDL
     * - documentation: Global Product Name or Optional Special Services | Name of the Value Added Service/Charge Type
     * @var string
     */
    public $ChargeType;
    /**
     * The ChargeAmount
     * Meta information extracted from the WSDL
     * - documentation: PackageCharge or the Weight Charge or Special Services Charge | The charge amount of the line item charge
     * @var string
     */
    public $ChargeAmount;
    /**
     * The ChargeName
     * Meta information extracted from the WSDL
     * - documentation: Name of the charge
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeName;
    /**
     * The ChargeCurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Currency code of the charge
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCurrencyCode;
    /**
     * The ChargeCodeTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Special service charge code type for service
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCodeTypeCode;
    /**
     * The BillingServiceInd
     * Meta information extracted from the WSDL
     * - documentation: Indicator if there is any discount allowed
     * - minOccurs: 0
     * @var string
     */
    public $BillingServiceInd;
    /**
     * The CustomerAgreementInd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerAgreementInd;
    /**
     * The MarketedServiceInd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MarketedServiceInd;
    /**
     * The ChargeBreakdown
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\ChargeBreakdown
     */
    public $ChargeBreakdown;
    /**
     * Constructor method for docTypeRef_ChargeType
     * @uses DocTypeRef_ChargeType::setChargeCode()
     * @uses DocTypeRef_ChargeType::setLocalChargeCode()
     * @uses DocTypeRef_ChargeType::setChargeType()
     * @uses DocTypeRef_ChargeType::setChargeAmount()
     * @uses DocTypeRef_ChargeType::setChargeName()
     * @uses DocTypeRef_ChargeType::setChargeCurrencyCode()
     * @uses DocTypeRef_ChargeType::setChargeCodeTypeCode()
     * @uses DocTypeRef_ChargeType::setBillingServiceInd()
     * @uses DocTypeRef_ChargeType::setCustomerAgreementInd()
     * @uses DocTypeRef_ChargeType::setMarketedServiceInd()
     * @uses DocTypeRef_ChargeType::setChargeBreakdown()
     * @param string $chargeCode
     * @param string $localChargeCode
     * @param string $chargeType
     * @param string $chargeAmount
     * @param string $chargeName
     * @param string $chargeCurrencyCode
     * @param string $chargeCodeTypeCode
     * @param string $billingServiceInd
     * @param string $customerAgreementInd
     * @param string $marketedServiceInd
     * @param \App\Delivery\Dhl\StructType\ChargeBreakdown $chargeBreakdown
     */
    public function __construct($chargeCode = null, $localChargeCode = null, $chargeType = null, $chargeAmount = null, $chargeName = null, $chargeCurrencyCode = null, $chargeCodeTypeCode = null, $billingServiceInd = null, $customerAgreementInd = null, $marketedServiceInd = null, \App\Delivery\Dhl\StructType\ChargeBreakdown $chargeBreakdown = null)
    {
        $this
            ->setChargeCode($chargeCode)
            ->setLocalChargeCode($localChargeCode)
            ->setChargeType($chargeType)
            ->setChargeAmount($chargeAmount)
            ->setChargeName($chargeName)
            ->setChargeCurrencyCode($chargeCurrencyCode)
            ->setChargeCodeTypeCode($chargeCodeTypeCode)
            ->setBillingServiceInd($billingServiceInd)
            ->setCustomerAgreementInd($customerAgreementInd)
            ->setMarketedServiceInd($marketedServiceInd)
            ->setChargeBreakdown($chargeBreakdown);
    }
    /**
     * Get ChargeCode value
     * @return string|null
     */
    public function getChargeCode()
    {
        return $this->ChargeCode;
    }
    /**
     * Set ChargeCode value
     * @param string $chargeCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ChargeType
     */
    public function setChargeCode($chargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCode) && !is_string($chargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeCode, true), gettype($chargeCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($chargeCode) && mb_strlen($chargeCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($chargeCode)), __LINE__);
        }
        $this->ChargeCode = $chargeCode;
        return $this;
    }
    /**
     * Get LocalChargeCode value
     * @return string|null
     */
    public function getLocalChargeCode()
    {
        return $this->LocalChargeCode;
    }
    /**
     * Set LocalChargeCode value
     * @param string $localChargeCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ChargeType
     */
    public function setLocalChargeCode($localChargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($localChargeCode) && !is_string($localChargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localChargeCode, true), gettype($localChargeCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($localChargeCode) && mb_strlen($localChargeCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($localChargeCode)), __LINE__);
        }
        $this->LocalChargeCode = $localChargeCode;
        return $this;
    }
    /**
     * Get ChargeType value
     * @return string|null
     */
    public function getChargeType()
    {
        return $this->ChargeType;
    }
    /**
     * Set ChargeType value
     * @param string $chargeType
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ChargeType
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: string
        if (!is_null($chargeType) && !is_string($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeType, true), gettype($chargeType)), __LINE__);
        }
        $this->ChargeType = $chargeType;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return string|null
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param string $chargeAmount
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ChargeType
     */
    public function setChargeAmount($chargeAmount = null)
    {
        // validation for constraint: string
        if (!is_null($chargeAmount) && !is_string($chargeAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeAmount, true), gettype($chargeAmount)), __LINE__);
        }
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get ChargeName value
     * @return string|null
     */
    public function getChargeName()
    {
        return $this->ChargeName;
    }
    /**
     * Set ChargeName value
     * @param string $chargeName
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ChargeType
     */
    public function setChargeName($chargeName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeName) && !is_string($chargeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeName, true), gettype($chargeName)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($chargeName) && mb_strlen($chargeName) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($chargeName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chargeName) && mb_strlen($chargeName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chargeName)), __LINE__);
        }
        $this->ChargeName = $chargeName;
        return $this;
    }
    /**
     * Get ChargeCurrencyCode value
     * @return string|null
     */
    public function getChargeCurrencyCode()
    {
        return $this->ChargeCurrencyCode;
    }
    /**
     * Set ChargeCurrencyCode value
     * @param string $chargeCurrencyCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ChargeType
     */
    public function setChargeCurrencyCode($chargeCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCurrencyCode) && !is_string($chargeCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeCurrencyCode, true), gettype($chargeCurrencyCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($chargeCurrencyCode) && mb_strlen($chargeCurrencyCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($chargeCurrencyCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chargeCurrencyCode) && mb_strlen($chargeCurrencyCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chargeCurrencyCode)), __LINE__);
        }
        $this->ChargeCurrencyCode = $chargeCurrencyCode;
        return $this;
    }
    /**
     * Get ChargeCodeTypeCode value
     * @return string|null
     */
    public function getChargeCodeTypeCode()
    {
        return $this->ChargeCodeTypeCode;
    }
    /**
     * Set ChargeCodeTypeCode value
     * @param string $chargeCodeTypeCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ChargeType
     */
    public function setChargeCodeTypeCode($chargeCodeTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCodeTypeCode) && !is_string($chargeCodeTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeCodeTypeCode, true), gettype($chargeCodeTypeCode)), __LINE__);
        }
        $this->ChargeCodeTypeCode = $chargeCodeTypeCode;
        return $this;
    }
    /**
     * Get BillingServiceInd value
     * @return string|null
     */
    public function getBillingServiceInd()
    {
        return $this->BillingServiceInd;
    }
    /**
     * Set BillingServiceInd value
     * @param string $billingServiceInd
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ChargeType
     */
    public function setBillingServiceInd($billingServiceInd = null)
    {
        // validation for constraint: string
        if (!is_null($billingServiceInd) && !is_string($billingServiceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingServiceInd, true), gettype($billingServiceInd)), __LINE__);
        }
        $this->BillingServiceInd = $billingServiceInd;
        return $this;
    }
    /**
     * Get CustomerAgreementInd value
     * @return string|null
     */
    public function getCustomerAgreementInd()
    {
        return $this->CustomerAgreementInd;
    }
    /**
     * Set CustomerAgreementInd value
     * @uses \App\Delivery\Dhl\EnumType\CustomerAgreementInd::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\CustomerAgreementInd::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customerAgreementInd
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ChargeType
     */
    public function setCustomerAgreementInd($customerAgreementInd = null)
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\CustomerAgreementInd::valueIsValid($customerAgreementInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\CustomerAgreementInd', is_array($customerAgreementInd) ? implode(', ', $customerAgreementInd) : var_export($customerAgreementInd, true), implode(', ', \App\Delivery\Dhl\EnumType\CustomerAgreementInd::getValidValues())), __LINE__);
        }
        $this->CustomerAgreementInd = $customerAgreementInd;
        return $this;
    }
    /**
     * Get MarketedServiceInd value
     * @return string|null
     */
    public function getMarketedServiceInd()
    {
        return $this->MarketedServiceInd;
    }
    /**
     * Set MarketedServiceInd value
     * @uses \App\Delivery\Dhl\EnumType\MarketedServiceInd::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\MarketedServiceInd::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $marketedServiceInd
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ChargeType
     */
    public function setMarketedServiceInd($marketedServiceInd = null)
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\MarketedServiceInd::valueIsValid($marketedServiceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\MarketedServiceInd', is_array($marketedServiceInd) ? implode(', ', $marketedServiceInd) : var_export($marketedServiceInd, true), implode(', ', \App\Delivery\Dhl\EnumType\MarketedServiceInd::getValidValues())), __LINE__);
        }
        $this->MarketedServiceInd = $marketedServiceInd;
        return $this;
    }
    /**
     * Get ChargeBreakdown value
     * @return \App\Delivery\Dhl\StructType\ChargeBreakdown|null
     */
    public function getChargeBreakdown()
    {
        return $this->ChargeBreakdown;
    }
    /**
     * Set ChargeBreakdown value
     * @param \App\Delivery\Dhl\StructType\ChargeBreakdown $chargeBreakdown
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ChargeType
     */
    public function setChargeBreakdown(\App\Delivery\Dhl\StructType\ChargeBreakdown $chargeBreakdown = null)
    {
        $this->ChargeBreakdown = $chargeBreakdown;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ChargeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
